/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.LifecycleHandler;
import de.iip_ecosphere.platform.support.PidLifecycleDescriptor;
import de.iip_ecosphere.platform.support.TerminatingLifecycleDescriptor;
import java.io.File;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleHandlerTest {
    private static String[] cmdArgs;
    private static int startupCount;
    private static int shutdownCount;
    private static int shutdownHookCount;
    private static int shutdownHookCalledCount;
    private static int countDescriptors;

    public static void setCmdArgs(String[] args) {
        cmdArgs = args;
    }

    @Test
    public void testLifecycleHandler() {
        LifecycleHandlerTest.setCmdArgs(new String[]{"arg1", "arg2"});
        startupCount = 0;
        shutdownCount = 0;
        shutdownHookCount = 0;
        shutdownHookCalledCount = 0;
        countDescriptors = 0;
        ServiceLoader.load(LifecycleDescriptor.class).forEach(l -> ++countDescriptors);
        Assert.assertEquals((long)2L, (long)countDescriptors);
        Assert.assertNotNull((Object)LifecycleHandler.descriptors());
        Assert.assertTrue((boolean)LifecycleHandler.getAnyDescriptor(LifecycleDescriptor.class).isPresent());
        LifecycleHandler.attachShutdownHooks();
        Assert.assertEquals((long)2L, (long)shutdownHookCount);
        LifecycleHandler.startup((String[])cmdArgs);
        Assert.assertArrayEquals((Object[])cmdArgs, (Object[])LifecycleHandler.getCmdArgs());
        Assert.assertEquals((long)2L, (long)startupCount);
        LifecycleHandler.shutdown();
        Assert.assertEquals((long)2L, (long)shutdownCount);
        startupCount = 0;
        shutdownCount = 0;
        shutdownHookCount = 0;
        shutdownHookCalledCount = 0;
        countDescriptors = 0;
        LifecycleHandler.OneShotStarter.main((String[])cmdArgs);
        Assert.assertTrue((boolean)new File(FileUtils.getTempDirectory(), "lcdesc2.pid").exists());
        Assert.assertEquals((long)2L, (long)shutdownHookCount);
        Assert.assertEquals((long)2L, (long)startupCount);
        Assert.assertEquals((long)2L, (long)shutdownCount);
    }

    @Test(timeout=10000L)
    public void testLifecycleHandlerWaiting() {
        cmdArgs = new String[]{"arg1", "arg2"};
        startupCount = 0;
        shutdownCount = 0;
        shutdownHookCount = 0;
        shutdownHookCalledCount = 0;
        countDescriptors = 0;
        LifecycleHandler.WaitingStarter.main((String[])cmdArgs);
        Assert.assertTrue((boolean)new File(FileUtils.getTempDirectory(), "lcdesc2.pid").exists());
        Assert.assertEquals((long)2L, (long)shutdownHookCount);
        Assert.assertEquals((long)2L, (long)startupCount);
    }

    @Test(timeout=10000L)
    public void testLifecycleHandlerWaitingShutdown() {
        cmdArgs = new String[]{"arg1", "arg2"};
        startupCount = 0;
        shutdownCount = 0;
        shutdownHookCount = 0;
        shutdownHookCalledCount = 0;
        countDescriptors = 0;
        LifecycleHandler.WaitingStarterWithShutdown.main((String[])cmdArgs);
        Assert.assertTrue((boolean)new File(FileUtils.getTempDirectory(), "lcdesc2.pid").exists());
        Assert.assertEquals((long)2L, (long)shutdownHookCount);
        Assert.assertEquals((long)2L, (long)startupCount);
        Assert.assertEquals((long)2L, (long)shutdownCount);
    }

    static {
        startupCount = 0;
        shutdownCount = 0;
        shutdownHookCount = 0;
        shutdownHookCalledCount = 0;
        countDescriptors = 0;
    }

    public static class LcDesc2
    implements TerminatingLifecycleDescriptor,
    PidLifecycleDescriptor {
        private int waitingCount = 0;

        public void startup(String[] args) {
            Assert.assertArrayEquals((Object[])args, (Object[])cmdArgs);
            ++startupCount;
        }

        public void shutdown() {
            ++shutdownCount;
        }

        public Thread getShutdownHook() {
            ++shutdownHookCount;
            return new Thread(() -> ++shutdownHookCalledCount);
        }

        public int priority() {
            return 100;
        }

        public boolean continueWaiting() {
            return this.waitingCount++ < 10;
        }

        public String getPidFileName() {
            return "lcdesc2.pid";
        }
    }

    public static class LcDesc1
    implements LifecycleDescriptor {
        public void startup(String[] args) {
            Assert.assertArrayEquals((Object[])args, (Object[])cmdArgs);
            ++startupCount;
        }

        public void shutdown() {
            ++shutdownCount;
        }

        public Thread getShutdownHook() {
            ++shutdownHookCount;
            return null;
        }

        public int priority() {
            return 1;
        }
    }
}

