/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.semanticId;

import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolverDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.slf4j.LoggerFactory;

public abstract class SemanticIdResolver {
    public static final String GERMAN = Locale.GERMAN.getLanguage();
    public static final String ENGLISH = Locale.ENGLISH.getLanguage();
    private static List<SemanticIdResolver> resolvers;

    public String getName() {
        return this.getClass().getName();
    }

    public abstract SemanticIdResolutionResult resolveSemanticId(String var1);

    public abstract boolean isResponsible(String var1);

    public static SemanticIdResolutionResult resolve(String semanticId) {
        SemanticIdResolutionResult result = null;
        SemanticIdResolver.initialize();
        for (SemanticIdResolver resolver : resolvers) {
            if (resolver.isResponsible(semanticId) && (result = resolver.resolveSemanticId(semanticId)) != null) break;
        }
        return result;
    }

    private static void initialize() {
        if (null == resolvers) {
            resolvers = new ArrayList<SemanticIdResolver>();
            ServiceLoader<SemanticIdResolverDescriptor> loader = ServiceLoader.load(SemanticIdResolverDescriptor.class);
            loader.forEach(l -> {
                SemanticIdResolver resolver = l.createResolver();
                resolvers.add(resolver);
                LoggerFactory.getLogger(SemanticIdResolver.class).info("Registered semanticId resolver {}", (Object)resolver.getName());
            });
        }
    }

    public static boolean hasResolver(Class<? extends SemanticIdResolver> cls) {
        boolean result = false;
        SemanticIdResolver.initialize();
        for (SemanticIdResolver resolver : resolvers) {
            if (!cls.isInstance(resolver)) continue;
            result = true;
            break;
        }
        return result;
    }
}

