/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class SslUtils {
    public static final String KEYSTORE_JKS = "JKS";
    public static final String KEYSTORE_PCKS12 = "PKCS12";
    public static final String TRUST_MANAGER_SUN_X509 = "SunX509";
    public static final String CONTEXT_ALG_TLS12 = "TLSv1.2";
    public static final String CONTEXT_ALG_TLS = "TLS";
    public static final String DEFAULT_CONTEXT_ALG = "TLS";

    public static final String getKeystoreType(File trustStore) {
        return SslUtils.getKeystoreType(trustStore.getName());
    }

    public static final String getKeystoreType(String tName) {
        String keystoreType = KEYSTORE_JKS;
        if (tName.endsWith(".p12")) {
            keystoreType = KEYSTORE_PCKS12;
        }
        return keystoreType;
    }

    public static KeyStore openKeyStore(File store, String storePass) throws IOException {
        KeyStore tks = null;
        if (null != store) {
            try {
                String keystoreType = SslUtils.getKeystoreType(store);
                tks = KeyStore.getInstance(keystoreType);
                InputStream stream = ResourceLoader.getResourceAsStream((String)store.toString(), (ResourceResolver[])new ResourceResolver[0]);
                if (null == stream) {
                    stream = new FileInputStream(store);
                }
                tks.load(stream, null == storePass ? null : storePass.toCharArray());
                stream.close();
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return tks;
    }

    public static TrustManagerFactory createTrustManagerFactory(File trustStore, String storePass) throws IOException {
        TrustManagerFactory tmf = null;
        if (null != trustStore) {
            tmf = SslUtils.createTrustManagerFactory(SslUtils.openKeyStore(trustStore, storePass));
        }
        return tmf;
    }

    public static TrustManagerFactory createTrustManagerFactory(KeyStore tks) throws IOException {
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TRUST_MANAGER_SUN_X509);
            tmf.init(tks);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return tmf;
    }

    public static SSLContext createTlsContext(File trustStore, String storePass) throws IOException {
        return SslUtils.createTlsContext(trustStore, storePass, null);
    }

    public static SSLContext createTlsContext(File trustStore, String storePass, String alias) throws IOException {
        return SslUtils.createTlsContext(trustStore, storePass, alias, "TLS");
    }

    public static SSLContext createTlsContext(File trustStore, String storePass, String alias, String contextAlg) throws IOException {
        SSLContext ctx = null;
        KeyStore ks = SslUtils.openKeyStore(trustStore, storePass);
        if (null != ks) {
            try {
                TrustManagerFactory tmf = SslUtils.createTrustManagerFactory(ks);
                KeyManager[] kms = SslUtils.createKeyManagers(ks, storePass, alias);
                ctx = SSLContext.getInstance(contextAlg);
                ctx.init(kms, tmf.getTrustManagers(), null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }
        return ctx;
    }

    public static KeyManager[] createKeyManagers(KeyStore ks, String storePass, String alias) throws IOException {
        KeyManager[] kms = null;
        if (null != alias) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, null == storePass ? null : storePass.toCharArray());
                kms = SslUtils.createProjectingKeyManagers(alias, kmf.getKeyManagers());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException(e);
            }
        }
        return kms;
    }

    public static KeyManager[] createProjectingKeyManagers(final String alias, KeyManager[] mgrs) {
        KeyManager[] kms = null;
        X509KeyManager tmp = null;
        X509KeyManager fallback = null;
        for (KeyManager m : mgrs) {
            if (!(m instanceof X509KeyManager)) continue;
            X509KeyManager xkm = (X509KeyManager)m;
            if (null == fallback) {
                fallback = xkm;
            }
            if (null == xkm.getPrivateKey(alias)) continue;
            tmp = xkm;
        }
        if (null == tmp) {
            tmp = fallback;
        }
        if (null != tmp) {
            final X509KeyManager origKm = tmp;
            X509KeyManager km = new X509KeyManager(){

                @Override
                public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                    return alias;
                }

                @Override
                public X509Certificate[] getCertificateChain(String alias2) {
                    return origKm.getCertificateChain(alias2);
                }

                @Override
                public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                    return origKm.chooseClientAlias(null, issuers, socket);
                }

                @Override
                public String[] getClientAliases(String keyType, Principal[] issuers) {
                    return origKm.getClientAliases(keyType, issuers);
                }

                @Override
                public PrivateKey getPrivateKey(String alias2) {
                    return origKm.getPrivateKey(alias2);
                }

                @Override
                public String[] getServerAliases(String keyType, Principal[] issuers) {
                    return origKm.getServerAliases(keyType, issuers);
                }
            };
            kms = new KeyManager[]{km};
        } else {
            kms = new KeyManager[]{};
        }
        return kms;
    }

    public static PublicKey readPublicKeySafe(File file, String algorithm) {
        PublicKey result;
        try {
            result = SslUtils.readPublicKey(file, algorithm);
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static PublicKey readPublicKey(File file, String algorithm) throws IOException {
        try {
            String key = new String(Files.readAllBytes(file.toPath()), Charset.defaultCharset());
            String publicKeyPEM = key.replace("-----BEGIN PUBLIC KEY-----", "").replaceAll("\r", "").replaceAll("\n", "").replace("-----END PUBLIC KEY-----", "");
            byte[] encoded = Base64.getDecoder().decode(publicKeyPEM);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }
}

