/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.net.LocalNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkManagerFactory {
    private static NetworkManager instance;

    public static NetworkManager getInstance() {
        if (null == instance) {
            Optional<NetworkManagerDescriptor> first = ServiceLoaderUtils.findFirst(NetworkManagerDescriptor.class);
            if (first.isPresent()) {
                instance = first.get().createInstance();
                if (null != instance) {
                    NetworkManagerFactory.getLogger().info("Network manager implementation registered: " + instance.getClass().getName());
                }
            } else {
                NetworkManagerFactory.getLogger().warn("No Network manager descriptor/implementation known. Falling back to local network manager.");
                instance = new LocalNetworkManagerImpl();
            }
        }
        return instance;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(NetworkManagerFactory.class);
    }

    public static void configure(NetworkManagerSetup setup) {
        NetworkManager mgr = NetworkManagerFactory.getInstance();
        if (null != mgr && null != setup) {
            mgr.configure(setup);
        }
    }
}

