/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.identities;

import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityStoreDescriptor;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.identities.YamlIdentityFile;
import de.iip_ecosphere.platform.support.net.SslUtils;
import de.iip_ecosphere.platform.support.net.UriResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.LoggerFactory;

public class YamlIdentityStore
extends IdentityStore {
    private YamlIdentityFile data = YamlIdentityFile.load(YamlIdentityStore.resolve("identityStore.yml"));

    public YamlIdentityStore() {
        LoggerFactory.getLogger(YamlIdentityFile.class).info("Loaded identityStore {}", (Object)this.data.getName());
    }

    private static InputStream resolve(String resource) {
        String source = "classpath";
        InputStream in = ResourceLoader.getResourceAsStream((String)resource, (ResourceResolver[])new ResourceResolver[0]);
        if (null == in) {
            in = ResourceLoader.getResourceAsStream((String)("resources/" + resource), (ResourceResolver[])new ResourceResolver[0]);
            source = "classpath: resources";
        }
        if (null == in) {
            String storeFolder = System.getProperty("iip.identityStore", ".");
            File f = new File(storeFolder, resource);
            if (!f.exists()) {
                f = new File("src/test/resources/" + resource);
            }
            if (!f.exists()) {
                f = new File("src/main/resources/" + resource);
            }
            if (f.exists()) {
                try {
                    in = new FileInputStream(f);
                    source = f.getAbsolutePath();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(YamlIdentityFile.class).info("Cannot load {}: {}", (Object)resource, (Object)e.getMessage());
                }
            } else {
                in = null;
            }
        }
        if (null != in) {
            LoggerFactory.getLogger(YamlIdentityFile.class).info("Loading {} from {}", (Object)resource, (Object)source);
        } else {
            LoggerFactory.getLogger(YamlIdentityFile.class).warn("{} not found!", (Object)resource);
        }
        return in;
    }

    private YamlIdentityFile.IdentityInformation resolve(String identity, String ... fallback) {
        YamlIdentityFile.IdentityInformation info = this.data.getData(identity);
        if (null == info) {
            String f;
            String[] stringArray = fallback;
            int n = stringArray.length;
            for (int i = 0; i < n && (info = this.data.getData(f = stringArray[i])) == null; ++i) {
            }
        }
        return info;
    }

    private YamlIdentityFile.IdentityInformation resolveWithLogging(String identity, String ... fallback) {
        YamlIdentityFile.IdentityInformation info = this.resolve(identity, fallback);
        if (null == info) {
            LoggerFactory.getLogger(this.getClass()).warn("No identity information found for {} in store {} (with fallbacks {})", new Object[]{identity, this.data.getName(), fallback});
        }
        return info;
    }

    @Override
    public IdentityToken getToken(String identity, boolean defltAnonymous, String ... fallback) {
        IdentityToken result = null;
        YamlIdentityFile.IdentityInformation info = this.resolve(identity, fallback);
        IdentityToken.IdentityTokenBuilder builder = null;
        if (null == info && defltAnonymous) {
            builder = IdentityToken.IdentityTokenBuilder.newBuilder();
        } else if (info != null) {
            builder = IdentityToken.IdentityTokenBuilder.newBuilder(info.getTokenPolicyId(), info.getSignatureAlgorithm(), info.getSignatureAsBytes());
            switch (info.getType()) {
                case ISSUED: {
                    builder.setIssuedToken(info.getTokenDataAsBytes(), info.getTokenEncryptionAlgorithm());
                    break;
                }
                case USERNAME: {
                    builder.setUsernameToken(info.getUserName(), info.getTokenDataAsBytes(), info.getTokenEncryptionAlgorithm());
                    break;
                }
                case X509: {
                    builder.setX509Token(info.getTokenDataAsBytes());
                    break;
                }
            }
        }
        if (null != builder) {
            result = builder.build();
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No identity information found for {} (with fallbacks {}) in store {}. Using anonymous token: {}", new Object[]{identity, fallback, this.data.getName(), defltAnonymous});
        }
        return result;
    }

    @Override
    public InputStream getKeystoreAsStream(String identity, String ... fallback) {
        InputStream result = null;
        YamlIdentityFile.IdentityInformation info = this.resolveForKeystore(identity, fallback);
        if (this.isOkForKeystore(info)) {
            try {
                URI uri = new URI(info.getFile());
                File f = UriResolver.resolveToFile(uri, null);
                if (null != f && f.exists()) {
                    result = new FileInputStream(f);
                }
            }
            catch (IllegalArgumentException | URISyntaxException uri) {
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Resolving key file {} failed: {}. Falling back to resource resolution.", (Object)info.getFile(), (Object)e.getMessage());
            }
            if (null == result) {
                result = YamlIdentityStore.resolve(info.getFile());
            }
        }
        return result;
    }

    @Override
    public KeyStore getKeystoreFile(String identity, String ... fallback) throws IOException {
        KeyStore result = null;
        YamlIdentityFile.IdentityInformation info = this.resolveForKeystore(identity, fallback);
        if (this.isOkForKeystore(info)) {
            try {
                InputStream stream = this.getKeystoreAsStream(identity, fallback);
                String keystoreType = SslUtils.getKeystoreType(info.getFile());
                result = KeyStore.getInstance(keystoreType);
                char[] pw = null == info.getTokenData() ? null : info.getTokenData().toCharArray();
                result.load(stream, pw);
                stream.close();
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    @Override
    public Key getKeystoreKey(String identity, KeyStore keystore, String alias, String ... fallback) throws IOException {
        Key key = null;
        YamlIdentityFile.IdentityInformation info = this.resolveForKeystore(identity, fallback);
        if (this.isOkForKeystore(info)) {
            if (null == keystore) {
                keystore = this.getKeystoreFile(identity, fallback);
            }
            try {
                key = keystore.getKey(alias, info.getTokenData().toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException(e.getMessage());
            }
        }
        return key;
    }

    private YamlIdentityFile.IdentityInformation resolveForKeystore(String identity, String ... fallback) {
        YamlIdentityFile.IdentityInformation info = this.resolveWithLogging(identity, fallback);
        if (info != null && !this.isOkForKeystore(info)) {
            if (IdentityToken.TokenType.USERNAME != info.getType()) {
                LoggerFactory.getLogger(this.getClass()).warn("Keystore information found for {} (with fallbacks {}), but type is not USERNAME", (Object)identity, (Object)fallback);
            } else if (null == info.getTokenData()) {
                LoggerFactory.getLogger(this.getClass()).warn("Keystore information found for {} (with fallbacks {}) with type USERNAME but it has no token data", (Object)identity, (Object)fallback);
            } else if (null == info.getFile()) {
                LoggerFactory.getLogger(this.getClass()).warn("Keystore information found for {} (with fallbacks {}), but no keystore file specified", (Object)identity, (Object)fallback);
            }
        }
        return info;
    }

    private boolean isOkForKeystore(YamlIdentityFile.IdentityInformation info) {
        return null != info && IdentityToken.TokenType.USERNAME == info.getType() && null != info.getFile();
    }

    @Override
    public KeyManager[] getKeyManagers(String identity, String algorithm, String ... fallback) throws IOException {
        KeyStore ks;
        KeyManager[] result = null;
        YamlIdentityFile.IdentityInformation info = this.resolveWithLogging(identity, fallback);
        if (null != info && null != (ks = this.getKeystoreFile(identity, fallback))) {
            try {
                KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
                factory.init(ks, info.getTokenData().toCharArray());
                result = factory.getKeyManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public static class YamlIdentityStoreDescriptor
    implements IdentityStoreDescriptor {
        @Override
        public IdentityStore createStore() {
            return new YamlIdentityStore();
        }
    }
}

