/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SimpleOperationsProvider
implements OperationsProvider {
    private static final String OP_PREFIX = "op_";
    private static final String SERVICE_PREFIX = "service_";
    private Map<String, Function<Object[], Object>> funcs = new HashMap<String, Function<Object[], Object>>();
    private Map<String, Supplier<Object>> get = new HashMap<String, Supplier<Object>>();
    private Map<String, Consumer<Object>> set = new HashMap<String, Consumer<Object>>();

    @Override
    public OperationsProvider defineOperation(String category, String name, Function<Object[], Object> function) {
        this.funcs.put(OP_PREFIX + category + "_" + name, function);
        return this;
    }

    @Override
    public Function<Object[], Object> getOperation(String category, String name) {
        return this.funcs.get(OP_PREFIX + category + "_" + name);
    }

    @Override
    public Function<Object[], Object> getServiceFunction(String name) {
        return this.funcs.get(SERVICE_PREFIX + name);
    }

    @Override
    public OperationsProvider defineServiceFunction(String name, Function<Object[], Object> function) {
        this.funcs.put(SERVICE_PREFIX + name, function);
        return this;
    }

    @Override
    public OperationsProvider defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
        this.get.put(name, get);
        this.set.put(name, set);
        return this;
    }

    @Override
    public Supplier<Object> getGetter(String name) {
        return this.get.get(name);
    }

    @Override
    public Consumer<Object> getSetter(String name) {
        return this.set.get(name);
    }
}

