/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SelectiveProtocolServerBuilder
implements ProtocolServerBuilder {
    private Predicate<String> propSelector;
    private Predicate<String> opSelector;
    private ProtocolServerBuilder builder1;
    private ProtocolServerBuilder builder2;

    public SelectiveProtocolServerBuilder(Predicate<String> propSelector, Predicate<String> opSelector, ProtocolServerBuilder builder1, ProtocolServerBuilder builder2) {
        this.propSelector = propSelector;
        this.opSelector = opSelector;
        this.builder1 = builder1;
        this.builder2 = builder2;
    }

    @Override
    public Server build() {
        return (Server)this.builder1.build();
    }

    @Override
    public ProtocolServerBuilder defineOperation(String name, Function<Object[], Object> function) {
        if (this.opSelector.test(name)) {
            this.builder1.defineOperation(name, function);
        } else {
            this.builder2.defineOperation(name, function);
        }
        return this;
    }

    @Override
    public ProtocolServerBuilder defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
        if (this.propSelector.test(name)) {
            this.builder1.defineProperty(name, get, set);
        } else {
            this.builder2.defineProperty(name, get, set);
        }
        return this;
    }

    @Override
    public ProtocolServerBuilder.PayloadCodec createPayloadCodec() {
        return this.builder1.createPayloadCodec();
    }

    @Override
    public boolean isAvailable(String host) {
        return this.builder1.isAvailable(host) || this.builder2.isAvailable(host);
    }
}

