/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ProtocolServerBuilder
extends Builder<Server> {
    public ProtocolServerBuilder defineOperation(String var1, Function<Object[], Object> var2);

    public ProtocolServerBuilder defineProperty(String var1, Supplier<Object> var2, Consumer<Object> var3);

    public PayloadCodec createPayloadCodec();

    public boolean isAvailable(String var1);

    default public boolean isAvailable(String host, int maxWaitingTime, int waitingPeriod) {
        boolean result = false;
        int timeTaken = 0;
        if (waitingPeriod <= 0) {
            waitingPeriod = 500;
        }
        while (timeTaken < maxWaitingTime) {
            if (this.isAvailable(host)) {
                result = true;
                break;
            }
            TimeUtils.sleep((int)waitingPeriod);
            timeTaken += waitingPeriod;
        }
        return result;
    }

    default public boolean isAvailable(String host, int maxWaitingTime) {
        return this.isAvailable(host, maxWaitingTime, 500);
    }

    public static interface PayloadConsumer {
        public void decoded(String var1, byte[] var2);
    }

    public static interface PayloadCodec {
        public Charset getCharset();

        public void setCharset(Charset var1);

        public Schema intendedSchema();

        public byte[] encode(String var1, byte[] var2);

        public int getDataBytesLength();

        public int decodeDataLength(byte[] var1);

        public void decode(byte[] var1, PayloadConsumer var2);
    }
}

