/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TaskRegistry {
    public static final TaskData NO_TASK = new TaskData("").setStatus(TaskStatus.UNKNOWN);
    private static long timeout = 120000L;
    private static Map<String, TaskData> idToData = new HashMap<String, TaskData>();
    private static Map<Long, TaskData> threadToData = new HashMap<Long, TaskData>();

    public static long getTimeout() {
        return timeout;
    }

    public static long setTimeout(long to) {
        long result = timeout;
        timeout = to;
        return result;
    }

    public static TaskData registerTask() {
        return TaskRegistry.registerTask(Thread.currentThread());
    }

    public static TaskData registerTask(String taskId) {
        return TaskRegistry.registerTask(Thread.currentThread(), taskId);
    }

    public static TaskData registerTask(Thread thread) {
        return TaskRegistry.registerTask(thread, null);
    }

    public static synchronized TaskData registerTask(Thread thread, String taskId) {
        TaskData data = new TaskData(taskId);
        long current = thread.getId();
        TaskData old = threadToData.remove(current);
        if (null != old && old.status == TaskStatus.RUNNING) {
            old.status = TaskStatus.SUPPRESSED;
        }
        threadToData.put(current, data);
        idToData.put(data.id, data);
        return data;
    }

    public static TaskData getTaskData() {
        return TaskRegistry.getTaskData(Thread.currentThread());
    }

    public static synchronized TaskData getTaskData(Thread thread) {
        TaskData result = threadToData.get(thread.getId());
        if (null == result) {
            result = NO_TASK;
        }
        return result;
    }

    public static synchronized TaskData getTaskData(String id) {
        TaskData result = idToData.get(id);
        if (null == result) {
            result = NO_TASK;
        }
        return result;
    }

    public static void stopTask() {
        TaskRegistry.stopTask(Thread.currentThread());
    }

    public static synchronized void stopTask(Thread thread) {
        TaskData data = threadToData.get(thread.getId());
        if (null != data) {
            data.setStatus(TaskStatus.STOPPED);
            threadToData.remove(thread.getId());
            idToData.remove(data.id);
        }
    }

    public static synchronized void stopTask(String id) {
        TaskData data = idToData.get(id);
        if (null != data) {
            data.setStatus(TaskStatus.STOPPED);
            threadToData.remove(data.threadId);
            idToData.remove(data.id);
        }
    }

    public static synchronized void cleanup() {
        long now = System.currentTimeMillis();
        TaskRegistry.cleanup(now, threadToData.values().iterator());
        TaskRegistry.cleanup(now, idToData.values().iterator());
    }

    private static void cleanup(long now, Iterator<TaskData> iter) {
        while (iter.hasNext()) {
            TaskData d = iter.next();
            if (d.getStatus() == TaskStatus.RUNNING || now - d.timestamp <= timeout) continue;
            iter.remove();
        }
    }

    public static class TaskData {
        private String id;
        private long threadId = Thread.currentThread().getId();
        private long timestamp;
        private TaskStatus status;

        private TaskData(String taskId) {
            this.id = null != taskId ? taskId : String.valueOf(System.currentTimeMillis()) + String.valueOf(this.threadId);
            this.setStatus(TaskStatus.RUNNING);
        }

        private TaskData setStatus(TaskStatus status) {
            this.status = status;
            this.timestamp = System.currentTimeMillis();
            return this;
        }

        public String getId() {
            return this.id;
        }

        public TaskStatus getStatus() {
            return this.status;
        }
    }

    public static enum TaskStatus {
        UNKNOWN,
        RUNNING,
        STOPPED,
        SUPPRESSED;

    }
}

