/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NetUtils {
    public static int getEphemeralPort() {
        int result = 0;
        try {
            ServerSocket s = new ServerSocket(0);
            result = s.getLocalPort();
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getOwnIP(String netMask) {
        String result = "127.0.0.1";
        if (null == netMask || ((String)netMask).length() == 0) {
            result = NetUtils.getOwnIP();
        } else {
            netMask = ((String)netMask).replaceAll("255", "\\\\d{1,3}");
            if (!((String)(netMask = ((String)netMask).replaceAll("\\.", "\\\\."))).startsWith("^")) {
                netMask = "^" + (String)netMask;
            }
            boolean found = false;
            try {
                Pattern pat = Pattern.compile((String)netMask);
                Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                while (ifs.hasMoreElements()) {
                    NetworkInterface ni = ifs.nextElement();
                    for (InterfaceAddress addr : ni.getInterfaceAddresses()) {
                        String tmp = addr.getAddress().getHostAddress();
                        if (!pat.matcher(tmp).matches()) continue;
                        result = tmp;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            catch (SocketException | PatternSyntaxException exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isOwnAddress(String host) {
        boolean isOwn = false;
        try {
            InetAddress givenHost = InetAddress.getByName(host);
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            block2: while (!isOwn && ifs.hasMoreElements()) {
                NetworkInterface ni = ifs.nextElement();
                for (InterfaceAddress addr : ni.getInterfaceAddresses()) {
                    if (!addr.getAddress().equals(givenHost)) continue;
                    isOwn = true;
                    continue block2;
                }
            }
        }
        catch (SocketException | UnknownHostException iOException) {
            // empty catch block
        }
        return isOwn;
    }

    public static String getOwnIP() {
        String ip = "";
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        catch (UncheckedIOException | SocketException | UnknownHostException e) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static String getOwnHostname() {
        String result;
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            result = "localhost";
        }
        return result;
    }

    public static boolean isAvailable(String host, int port) {
        boolean result = false;
        try {
            Socket sock = new Socket(host, port);
            sock.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

