/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileFormat;
import java.io.File;

public class ExtensionBasedFileFormat
extends FileFormat {
    private String extension;

    public ExtensionBasedFileFormat(String extension, String name, String description) {
        super(name, description);
        String string = this.extension = null == extension ? "" : extension;
        while (this.extension.startsWith(".")) {
            this.extension = this.extension.substring(1);
        }
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean matches(File file) {
        boolean result = this.extension.length() > 0 ? file.getName().endsWith("." + this.extension) : true;
        return result;
    }

    @Override
    public String toString() {
        Object result = this.getName();
        Object desc = this.getExtension();
        if (((String)desc).length() > 0) {
            desc = "*." + (String)desc;
        }
        if (this.getDescription().length() > 0) {
            if (((String)desc).length() > 0) {
                desc = (String)desc + ", ";
            }
            desc = (String)desc + this.getDescription();
        }
        if (((String)desc).length() > 0) {
            result = (String)result + " (" + (String)desc + ")";
        }
        return result;
    }
}

