/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;

public class Endpoint
extends ServerAddress {
    private String endpoint;

    public Endpoint(Schema schema, String endpoint) {
        super(schema);
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public Endpoint(Schema schema, int port, String endpoint) {
        super(schema, port);
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public Endpoint(Schema schema, String host, int port, String endpoint) {
        super(schema, host, port);
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public Endpoint(ServerAddress server, String endpoint) {
        super(server.getSchema(), server.getHost(), server.getPort());
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String toUri() {
        return super.toUri() + this.endpoint;
    }

    public static String checkEndpoint(String endpoint) {
        if (null == endpoint) {
            endpoint = "";
        }
        if (((String)endpoint).length() > 0 && !((String)endpoint).startsWith("/")) {
            endpoint = "/" + (String)endpoint;
        }
        return endpoint;
    }

    @Override
    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof Endpoint) {
            Endpoint o = (Endpoint)other;
            result = super.equals(other) && this.endpoint.equals(o.endpoint);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.endpoint.hashCode();
    }
}

