/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    @SafeVarargs
    public static <T> List<T> toList(T ... elements) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : elements) {
            result.add(e);
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> addAll(List<T> list, T ... elements) {
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> addAll(Set<T> set, T ... elements) {
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T> Set<T> toSet(Iterator<T> iterator) {
        HashSet<T> result = new HashSet<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

