/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.util.Optional;
import java.util.logging.Logger;

public class NetworkManagerFactory {
    private static final Logger LOGGER = Logger.getLogger(NetworkManagerFactory.class.getName());
    private static NetworkManager instance;

    public static NetworkManager getInstance() {
        if (null == instance) {
            Optional<NetworkManagerDescriptor> first = ServiceLoaderUtils.findFirst(NetworkManagerDescriptor.class);
            if (first.isPresent()) {
                instance = first.get().createInstance();
                if (null != instance) {
                    LOGGER.fine("Network manager implementation registered: " + instance.getClass().getName());
                }
            } else {
                LOGGER.severe("No Network manager implementation known.");
            }
        }
        return instance;
    }

    public static void configure(NetworkManagerSetup setup) {
        NetworkManager mgr = NetworkManagerFactory.getInstance();
        if (null != mgr && null != setup) {
            mgr.configure(setup);
        }
    }
}

