/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.net.AbstractNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LocalNetworkManagerImpl
extends AbstractNetworkManagerImpl {
    private Map<String, ServerAddress> keyToAddress = new HashMap<String, ServerAddress>();
    private Map<Integer, String> portToKey = new HashMap<Integer, String>();
    private String host = NetUtils.getOwnIP();
    private NetworkManager parent;

    public LocalNetworkManagerImpl() {
    }

    public LocalNetworkManagerImpl(NetworkManager parent) {
        this.parent = parent;
    }

    @Override
    public synchronized ManagedServerAddress obtainPort(String key) {
        ManagedServerAddress result = this.getPort(key);
        if (null == result) {
            do {
                int port;
                if (!this.portToKey.containsKey(port = NetUtils.getEphemeralPort())) {
                    ServerAddress address = new ServerAddress(Schema.IGNORE, this.host, port);
                    this.keyToAddress.put(key, address);
                    this.portToKey.put(port, key);
                    result = new ManagedServerAddress(address, true);
                    LoggerFactory.getLogger(LocalNetworkManagerImpl.class).info("Allocated port " + key + " " + port);
                    continue;
                }
                result = null;
            } while (result == null);
        }
        return result;
    }

    @Override
    public ManagedServerAddress getPort(String key) {
        LocalNetworkManagerImpl.checkKey(key);
        ServerAddress ex = null;
        if (null != this.parent) {
            ex = this.parent.getPort(key);
        }
        if (null == ex) {
            int pos = key.lastIndexOf(".");
            while (pos > 0 && null == ex) {
                String sub = key.substring(0, pos + 1);
                ex = this.keyToAddress.get(sub);
                pos = key.lastIndexOf(".", pos - 1);
            }
        }
        if (null == ex) {
            ex = this.keyToAddress.get(key);
        }
        ManagedServerAddress result = null;
        if (null != ex) {
            result = new ManagedServerAddress(ex, false);
        }
        return result;
    }

    @Override
    public ManagedServerAddress reservePort(String key, ServerAddress address) {
        LocalNetworkManagerImpl.checkAddress(address);
        ManagedServerAddress result = this.getPort(key);
        if (null == result) {
            this.keyToAddress.put(key, address);
            this.portToKey.put(address.getPort(), key);
            result = new ManagedServerAddress(address, true);
            LoggerFactory.getLogger(LocalNetworkManagerImpl.class).info("Reserved port " + key + " " + address.getHost() + " " + address.getPort());
        }
        return result;
    }

    @Override
    public synchronized void releasePort(String key) {
        LocalNetworkManagerImpl.checkKey(key);
        ServerAddress ex = this.keyToAddress.remove(key);
        if (null != ex) {
            this.portToKey.remove(ex.getPort());
            LoggerFactory.getLogger(LocalNetworkManagerImpl.class).info("Released port " + key);
        }
    }

    @Override
    public synchronized boolean isInUse(int port) {
        return this.portToKey.containsKey(port);
    }

    @Override
    public boolean isInUse(ServerAddress adr) {
        LocalNetworkManagerImpl.checkAddress(adr);
        return this.host.equals(adr.getHost()) && this.isInUse(adr.getPort());
    }

    @Override
    public void configure(NetworkManagerSetup setup) {
        super.configure(setup);
        if (null != setup) {
            this.host = NetUtils.getOwnIP(this.getNetmask());
        }
    }

    public static class Descriptor
    implements NetworkManagerDescriptor {
        @Override
        public NetworkManager createInstance() {
            return new LocalNetworkManagerImpl();
        }
    }
}

