/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.jsl;

import de.iip_ecosphere.platform.support.jsl.ExcludeFirst;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class ServiceLoaderUtils {
    public static <D> Optional<D> filterExcluded(Class<D> descriptorClass) {
        ServiceLoader<D> loader = ServiceLoader.load(descriptorClass);
        Optional<Object> first = ServiceLoaderUtils.stream(loader).filter(d -> !ServiceLoaderUtils.hasExcludeFirst(d)).findFirst();
        if (!first.isPresent()) {
            first = ServiceLoaderUtils.findFirst(loader);
        }
        return first;
    }

    public static <D> Optional<D> findFirst(Class<D> descriptorClass) {
        return ServiceLoaderUtils.findFirst(ServiceLoader.load(descriptorClass));
    }

    public static <D> Optional<D> findFirst(ServiceLoader<D> loader) {
        Iterator<D> iterator = loader.iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    public static <D> Stream<D> stream(ServiceLoader<D> loader) {
        ArrayList<D> result = new ArrayList<D>();
        Iterator<D> iterator = loader.iterator();
        while (iterator.hasNext()) {
            try {
                result.add(iterator.next());
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return result.stream();
    }

    public static boolean hasExcludeFirst(Object instance) {
        return null != instance && instance.getClass().isAnnotationPresent(ExcludeFirst.class);
    }
}

