/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Asset;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import java.util.concurrent.ExecutionException;

public class AasPrintVisitor
implements AasVisitor {
    private String indentation = "";

    private void increaseIndentation() {
        this.indentation = this.indentation + " ";
    }

    private void decreaseIndentation() {
        if (this.indentation.length() > 0) {
            this.indentation = this.indentation.substring(0, this.indentation.length() - 1);
        }
    }

    private void log(String text) {
        System.out.println(this.indentation + text);
    }

    @Override
    public void visitAas(Aas aas) {
        this.log("AAS " + aas.getIdShort());
        this.increaseIndentation();
    }

    @Override
    public void endAas(Aas aas) {
        this.decreaseIndentation();
    }

    @Override
    public void visitAsset(Asset asset) {
        this.log("ASSET " + asset.getIdShort() + " " + (Object)((Object)asset.getAssetKind()));
    }

    @Override
    public void visitSubmodel(Submodel submodel) {
        this.log("SUBMODEL " + submodel.getIdShort());
        this.increaseIndentation();
    }

    @Override
    public void endSubmodel(Submodel submodel) {
        this.decreaseIndentation();
    }

    @Override
    public void visitProperty(Property property) {
        String value;
        try {
            value = String.valueOf(property.getValue());
        }
        catch (ExecutionException e) {
            value = "?";
        }
        this.log("PROPERTY " + property.getIdShort() + " = " + value);
    }

    @Override
    public void visitOperation(Operation operation) {
        this.log("OPERATION " + operation.getIdShort() + " #args " + operation.getArgsCount());
    }

    @Override
    public void visitReferenceElement(ReferenceElement referenceElement) {
        this.log("REFERENCE " + referenceElement.getIdShort() + " = " + referenceElement.getValue());
    }

    @Override
    public void visitSubmodelElementCollection(SubmodelElementCollection collection) {
        this.log("COLLECTION " + collection.getIdShort());
        this.increaseIndentation();
    }

    @Override
    public void endSubmodelElementCollection(SubmodelElementCollection collection) {
        this.decreaseIndentation();
    }
}

