/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactoryDescriptor;
import de.iip_ecosphere.platform.support.aas.AasServerRecipeDescriptor;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolDescriptor;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.jsl.ExcludeFirst;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public abstract class AasFactory {
    public static final String DEFAULT_PROTOCOL = "";
    public static final AasFactory DUMMY = new AasFactory(){

        @Override
        public String getName() {
            return "Dummy";
        }

        @Override
        public Aas.AasBuilder createAasBuilder(String idShort, String urn) {
            return null;
        }

        @Override
        public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String urn) {
            return null;
        }

        @Override
        protected ServerRecipe createDefaultServerRecipe() {
            return null;
        }

        @Override
        public Registry obtainRegistry(Endpoint regEndpoint) throws IOException {
            return new Registry(){

                @Override
                public Aas retrieveAas(String aasUrn) throws IOException {
                    return null;
                }

                @Override
                public Submodel retrieveSubmodel(String aasUrn, String submodelUrn) throws IOException {
                    return null;
                }

                @Override
                public void createAas(Aas aas, String endpointURL) {
                }

                @Override
                public void createSubmodel(Aas aas, Submodel submodel) {
                }

                @Override
                public void register(Aas aas, Submodel submodel, String endpointUrl) {
                }
            };
        }

        @Override
        public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint) {
            return null;
        }

        @Override
        public PersistenceRecipe createPersistenceRecipe() {
            return null;
        }

        @Override
        protected boolean accept(ProtocolDescriptor creator) {
            return true;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(AasFactory.class.getName());
    private static AasFactory instance = DUMMY;
    private Map<String, ProtocolCreator> protocolCreators = new HashMap<String, ProtocolCreator>();
    private String[] protocols;

    protected AasFactory() {
        ServiceLoader<ProtocolDescriptor> loader = ServiceLoader.load(ProtocolDescriptor.class);
        for (ProtocolDescriptor desc : loader) {
            if (!this.accept(desc)) continue;
            ProtocolCreator creator = desc.createInstance();
            this.registerProtocolCreator(desc.getName(), creator);
            if (1 != this.protocolCreators.size()) continue;
            this.registerProtocolCreator(DEFAULT_PROTOCOL, creator);
        }
    }

    protected boolean accept(ProtocolDescriptor creator) {
        return !creator.getClass().isAnnotationPresent(ExcludeFirst.class);
    }

    public String[] getProtocols() {
        if (null == this.protocols) {
            this.protocols = new String[this.protocolCreators.size()];
            this.protocolCreators.keySet().toArray(this.protocols);
        }
        return this.protocols;
    }

    public static AasFactory getInstance() {
        if (DUMMY == instance) {
            Optional<AasFactoryDescriptor> first = ServiceLoaderUtils.filterExcluded(AasFactoryDescriptor.class);
            if (first.isPresent()) {
                instance = first.get().createInstance();
                if (null != instance) {
                    LOGGER.fine("AAS factory implementation registered: " + instance.getClass().getName());
                }
            } else {
                LOGGER.severe("No AAS factory implementation known.");
            }
        }
        return instance;
    }

    public static boolean isFullInstance() {
        return AasFactory.isFullInstance(AasFactory.getInstance());
    }

    public static boolean isFullInstance(AasFactory factory) {
        return factory != DUMMY && !ServiceLoaderUtils.hasExcludeFirst(factory);
    }

    public static AasFactory setInstance(AasFactory newInstance) {
        AasFactory oldInstance = instance;
        if (null != newInstance) {
            instance = newInstance;
        }
        return oldInstance;
    }

    protected void registerProtocolCreator(String protocol, ProtocolCreator creator) {
        this.protocolCreators.put(protocol, creator);
    }

    public abstract String getName();

    public abstract Aas.AasBuilder createAasBuilder(String var1, String var2);

    public abstract Submodel.SubmodelBuilder createSubmodelBuilder(String var1, String var2);

    public final ServerRecipe createServerRecipe() {
        ServerRecipe result = null;
        Optional<AasServerRecipeDescriptor> first = ServiceLoaderUtils.filterExcluded(AasServerRecipeDescriptor.class);
        if (first.isPresent()) {
            result = first.get().createInstance();
        }
        if (null == result) {
            result = this.createDefaultServerRecipe();
        }
        return result;
    }

    protected abstract ServerRecipe createDefaultServerRecipe();

    public abstract Registry obtainRegistry(Endpoint var1) throws IOException;

    public abstract DeploymentRecipe createDeploymentRecipe(Endpoint var1);

    public abstract PersistenceRecipe createPersistenceRecipe();

    public InvocablesCreator createInvocablesCreator(String protocol, String host, int port) {
        ProtocolCreator creator = this.protocolCreators.get(protocol);
        if (null == creator) {
            throw new IllegalArgumentException("Unknown/unregistered protocol: " + protocol);
        }
        return creator.createInvocablesCreator(host, port);
    }

    public ProtocolServerBuilder createProtocolServerBuilder(String protocol, int port) {
        ProtocolCreator creator = this.protocolCreators.get(protocol);
        if (null == creator) {
            throw new IllegalArgumentException("Unknown/unregistered protocol: " + protocol);
        }
        return creator.createProtocolServerBuilder(port);
    }

    public String fixId(String id) {
        String result = id;
        if (id != null && id.length() > 0) {
            if (!Character.isAlphabetic(id.charAt(0))) {
                id = "a" + id;
            }
            result = DEFAULT_PROTOCOL;
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                result = Character.isAlphabetic(c) || Character.isDigit(c) || c == '_' ? result + c : result + "_";
            }
        }
        return result;
    }

    public static interface ProtocolCreator {
        public InvocablesCreator createInvocablesCreator(String var1, int var2);

        public ProtocolServerBuilder createProtocolServerBuilder(int var1);
    }
}

