/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NetUtils {
    public static int getEphemeralPort() {
        int result = 0;
        try {
            ServerSocket s = new ServerSocket(0);
            result = s.getLocalPort();
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getOwnIP(String netMask) {
        String result = "127.0.0.1";
        if (null == netMask || netMask.length() == 0) {
            result = NetUtils.getOwnIP();
        } else {
            netMask = netMask.replaceAll("255", "\\\\d{1,3}");
            if (!(netMask = netMask.replaceAll("\\.", "\\\\.")).startsWith("^")) {
                netMask = "^" + netMask;
            }
            boolean found = false;
            try {
                Pattern pat = Pattern.compile(netMask);
                Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                while (ifs.hasMoreElements()) {
                    NetworkInterface ni = ifs.nextElement();
                    for (InterfaceAddress addr : ni.getInterfaceAddresses()) {
                        String tmp = addr.getAddress().getHostAddress();
                        if (!pat.matcher(tmp).matches()) continue;
                        result = tmp;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            catch (SocketException socketException) {
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getOwnIP() {
        String ip = "";
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        catch (SocketException | UnknownHostException e) {
            ip = "127.0.0.1";
        }
        return ip;
    }
}

