/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.LifecycleExclude;
import de.iip_ecosphere.platform.support.TerminatingLifecycleDescriptor;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class LifecycleHandler {
    private static List<LifecycleDescriptor> descriptors;

    public static void startup(String[] args) {
        LifecycleHandler.forEach(l -> {
            LoggerFactory.getLogger(LifecycleHandler.class).info("Starting " + l.getClass().getName() + " (" + l.priority() + ")");
            l.startup(args);
        }, false);
        LoggerFactory.getLogger(LifecycleHandler.class).info("Startup completed.");
    }

    public static void shutdown() {
        LifecycleHandler.forEach(l -> {
            LoggerFactory.getLogger(LifecycleHandler.class).info("Stopping " + l.getClass().getName() + " (" + l.priority() + ")");
            l.shutdown();
        }, true);
    }

    public static void attachShutdownHooks() {
        LifecycleHandler.forEach(l -> {
            Thread t = l.getShutdownHook();
            if (null != t) {
                Runtime.getRuntime().addShutdownHook(t);
            }
        }, true);
    }

    private static void forEach(Consumer<LifecycleDescriptor> consumer, boolean revert) {
        ArrayList<LifecycleDescriptor> desc = new ArrayList<LifecycleDescriptor>(LifecycleHandler.getDescriptors());
        HashSet<Object> excluded = new HashSet<Object>();
        for (LifecycleDescriptor d : desc) {
            LifecycleExclude exclude = d.getClass().getAnnotation(LifecycleExclude.class);
            if (null == exclude) continue;
            for (Class<?> c : exclude.value()) {
                excluded.add(c.getName());
            }
            for (String s : exclude.names()) {
                excluded.add(s);
            }
        }
        int factor = revert ? -1 : 1;
        Collections.sort(desc, (d1, d2) -> factor * Integer.compare(d1.priority(), d2.priority()));
        for (LifecycleDescriptor d : desc) {
            if (excluded.contains(d.getClass().getName())) continue;
            consumer.accept(d);
        }
    }

    private static List<LifecycleDescriptor> getDescriptors() {
        if (null == descriptors) {
            descriptors = CollectionUtils.toList(ServiceLoader.load(LifecycleDescriptor.class).iterator());
        }
        return descriptors;
    }

    public static boolean continueWaiting() {
        boolean cont = true;
        List<LifecycleDescriptor> desc = LifecycleHandler.getDescriptors();
        for (int l = 0; cont && l < desc.size(); ++l) {
            LifecycleDescriptor d = desc.get(l);
            if (!(d instanceof TerminatingLifecycleDescriptor)) continue;
            cont = ((TerminatingLifecycleDescriptor)d).continueWaiting();
        }
        return cont;
    }

    public static void waitUntilEnd(String[] args) {
        LifecycleHandler.waitUntilEnd(args, true);
    }

    public static void waitUntilEnd(String[] args, boolean shutdownAsHook) {
        LifecycleHandler.attachShutdownHooks();
        if (shutdownAsHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> LifecycleHandler.shutdown()));
        }
        LifecycleHandler.startup(args);
        while (LifecycleHandler.continueWaiting()) {
            TimeUtils.sleep(500);
        }
        if (!shutdownAsHook) {
            LifecycleHandler.shutdown();
        }
    }

    public static List<LifecycleDescriptor> descriptors() {
        return Collections.unmodifiableList(LifecycleHandler.getDescriptors());
    }

    public static <L extends LifecycleDescriptor> Optional<L> getAnyDescriptor(Class<L> cls) {
        return LifecycleHandler.descriptors().stream().filter(d -> cls.isInstance(d)).map(d -> (LifecycleDescriptor)cls.cast(d)).findAny();
    }

    public static class WaitingStarterWithShutdown {
        public static void main(String[] args) {
            LifecycleHandler.waitUntilEnd(args, false);
        }
    }

    public static class WaitingStarter {
        public static void main(String[] args) {
            LifecycleHandler.waitUntilEnd(args);
        }
    }

    public static class OneShotStarter {
        public static void main(String[] args) {
            LifecycleHandler.attachShutdownHooks();
            LifecycleHandler.startup(args);
            LifecycleHandler.shutdown();
        }
    }
}

