/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarUtils {
    public static InputStream findFile(InputStream in, String name) throws IOException {
        ZipInputStream found = null;
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equals(name)) {
                found = zis;
                break;
            }
            zipEntry = zis.getNextEntry();
        }
        if (null == found) {
            zis.closeEntry();
            zis.close();
        }
        return found;
    }

    public static void extractZip(InputStream in, Path target) throws IOException {
        JarUtils.extractZip(in, target, null);
    }

    public static Predicate<ZipEntry> inFolder(String folder) {
        return z -> z.getName().equals(folder) || z.getName().startsWith(folder + "/");
    }

    public static void extractZip(InputStream in, Path target, Predicate<ZipEntry> pred) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = zipEntry.isDirectory();
                if (null == pred || pred.test(zipEntry)) {
                    Path newPath = JarUtils.zipSlipProtect(zipEntry, target);
                    if (isDirectory) {
                        Files.createDirectories(newPath, new FileAttribute[0]);
                    } else {
                        if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }
}

