/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import java.util.HashMap;
import java.util.Map;

public class LocalNetworkManagerImpl
implements NetworkManager {
    private Map<String, Integer> keyToPorts = new HashMap<String, Integer>();
    private Map<Integer, String> portsToKeys = new HashMap<Integer, String>();
    private String host = NetUtils.getOwnIP();

    @Override
    public synchronized ManagedServerAddress obtainPort(String key) {
        if (null == key) {
            throw new IllegalArgumentException("Key must be given");
        }
        ManagedServerAddress result = null;
        Integer ex = this.keyToPorts.get(key);
        if (null != ex) {
            result = new ManagedServerAddress(Schema.IGNORE, this.host, ex, false);
        } else {
            do {
                int port;
                if (!this.portsToKeys.containsKey(port = NetUtils.getEphemeralPort())) {
                    this.keyToPorts.put(key, port);
                    this.portsToKeys.put(port, key);
                    result = new ManagedServerAddress(Schema.IGNORE, this.host, port, true);
                    continue;
                }
                result = null;
            } while (result == null);
        }
        return result;
    }

    @Override
    public synchronized void releasePort(String key) {
        if (null == key) {
            throw new IllegalArgumentException("Key must be given");
        }
        Integer port = this.keyToPorts.remove(key);
        if (null != port) {
            this.portsToKeys.remove(port);
        }
    }

    @Override
    public synchronized boolean isInUse(int port) {
        return this.portsToKeys.containsKey(port);
    }

    @Override
    public boolean isInUse(ServerAddress adr) {
        return this.host.equals(adr.getHost()) && this.isInUse(adr.getPort());
    }

    @Override
    public int getLowPort() {
        return 1025;
    }

    @Override
    public int getHighPort() {
        return 65535;
    }
}

