/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactoryDescriptor;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public abstract class AasFactory {
    public static final String DEFAULT_PROTOCOL = "";
    public static final AasFactory DUMMY = new AasFactory(){

        @Override
        public String getName() {
            return "Dummy";
        }

        @Override
        public Aas.AasBuilder createAasBuilder(String idShort, String urn) {
            return null;
        }

        @Override
        public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String urn) {
            return null;
        }

        @Override
        public Server createRegistryServer(Endpoint endpoint, String ... options) {
            return null;
        }

        @Override
        public Registry obtainRegistry(Endpoint regEndpoint) throws IOException {
            return new Registry(){

                @Override
                public Aas retrieveAas(String aasUrn) throws IOException {
                    return null;
                }

                @Override
                public Submodel retrieveSubmodel(String aasUrn, String submodelUrn) throws IOException {
                    return null;
                }

                @Override
                public void createAas(Aas aas, String endpointURL) {
                }

                @Override
                public void createSubmodel(Aas aas, Submodel submodel) {
                }

                @Override
                public void register(Aas aas, Submodel submodel, String endpointUrl) {
                }
            };
        }

        @Override
        public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint) {
            return null;
        }

        @Override
        public PersistenceRecipe createPersistenceRecipe() {
            return null;
        }

        @Override
        public String[] getProtocols() {
            return new String[]{AasFactory.DEFAULT_PROTOCOL};
        }

        @Override
        public InvocablesCreator createInvocablesCreator(String protocol, String host, int port) {
            return null;
        }

        @Override
        public ProtocolServerBuilder createProtocolServerBuilder(String protocol, int port) {
            return null;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(AasFactory.class.getName());
    private static AasFactory instance = DUMMY;

    public static AasFactory getInstance() {
        if (DUMMY == instance) {
            ServiceLoader<AasFactoryDescriptor> loader = ServiceLoader.load(AasFactoryDescriptor.class);
            Optional<AasFactoryDescriptor> first = loader.findFirst();
            if (first.isPresent()) {
                instance = first.get().createInstance();
                if (null != instance) {
                    LOGGER.fine("AAS factory implementation registered: " + instance.getClass().getName());
                }
            } else {
                LOGGER.severe("No AAS factory implementation known.");
            }
        }
        return instance;
    }

    public static AasFactory setInstance(AasFactory newInstance) {
        AasFactory oldInstance = instance;
        if (null != newInstance) {
            instance = newInstance;
        }
        return oldInstance;
    }

    public abstract String getName();

    public abstract Aas.AasBuilder createAasBuilder(String var1, String var2);

    public abstract Submodel.SubmodelBuilder createSubmodelBuilder(String var1, String var2);

    public abstract Server createRegistryServer(Endpoint var1, String ... var2);

    public abstract Registry obtainRegistry(Endpoint var1) throws IOException;

    public abstract DeploymentRecipe createDeploymentRecipe(Endpoint var1);

    public abstract PersistenceRecipe createPersistenceRecipe();

    public abstract String[] getProtocols();

    public abstract InvocablesCreator createInvocablesCreator(String var1, String var2, int var3);

    public abstract ProtocolServerBuilder createProtocolServerBuilder(String var1, int var2);
}

