/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;

public class ServerAddress {
    public static final String LOCALHOST = "localhost";
    private Schema schema;
    private String host;
    private int port;

    public ServerAddress(Schema schema) {
        this(schema, LOCALHOST, NetUtils.getEphemeralPort());
    }

    public ServerAddress(Schema schema, int port) {
        this(schema, LOCALHOST, port);
    }

    public ServerAddress(Schema schema, String host, int port) {
        this.schema = schema;
        this.host = host;
        if (null == this.host || this.host.length() == 0) {
            this.host = LOCALHOST;
        }
        this.port = port;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toUri() {
        return this.toServerUri();
    }

    public final String toServerUri() {
        return this.schema.toUri() + this.host + ":" + this.port;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ServerAddress) {
            ServerAddress o = (ServerAddress)other;
            result = this.schema == o.schema && this.host.equals(o.host) && this.port == o.port;
        }
        return result;
    }

    public int hashCode() {
        return this.schema.ordinal() ^ this.host.hashCode() ^ this.port;
    }
}

