/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.net.LocalNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import org.junit.Assert;
import org.junit.Test;

public class NetworkManagerTest {
    @Test
    public void testNetworkManagers() {
        NetworkManagerTest.testNetworkManager((NetworkManager)new LocalNetworkManagerImpl());
    }

    public static void testNetworkManager(NetworkManager manager) {
        Assert.assertTrue((manager.getLowPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getHighPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getLowPort() < manager.getHighPort() ? 1 : 0) != 0);
        int port = NetUtils.getEphemeralPort();
        while (port < manager.getLowPort() || port > manager.getHighPort()) {
            port = NetUtils.getEphemeralPort();
        }
        ServerAddress adr = new ServerAddress(Schema.IGNORE, "localhost", port);
        Assert.assertFalse((boolean)manager.isInUse(port));
        Assert.assertFalse((boolean)manager.isInUse(adr));
        try {
            manager.obtainPort(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            manager.releasePort(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String key1 = "key1";
        String key2 = "key2";
        ManagedServerAddress adr1 = manager.obtainPort("key1");
        Assert.assertTrue((boolean)adr1.isNew());
        Assert.assertTrue((adr1.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((adr1.getHost().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)manager.isInUse(adr1.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)adr1));
        ManagedServerAddress re1 = manager.obtainPort("key1");
        Assert.assertFalse((boolean)re1.isNew());
        Assert.assertEquals((long)adr1.getPort(), (long)re1.getPort());
        Assert.assertEquals((Object)adr1.getHost(), (Object)re1.getHost());
        Assert.assertTrue((boolean)manager.isInUse(re1.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)re1));
        ManagedServerAddress adr2 = manager.obtainPort("key2");
        Assert.assertTrue((boolean)adr1.isNew());
        Assert.assertTrue((adr2.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((adr2.getHost().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((adr1.getPort() != adr2.getPort() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)manager.isInUse(adr2.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)adr2));
        ManagedServerAddress re2 = manager.obtainPort("key2");
        Assert.assertFalse((boolean)re2.isNew());
        Assert.assertEquals((long)adr2.getPort(), (long)re2.getPort());
        Assert.assertEquals((Object)adr2.getHost(), (Object)re2.getHost());
        Assert.assertTrue((boolean)manager.isInUse(re2.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)re2));
        manager.releasePort("key1");
        Assert.assertFalse((boolean)manager.isInUse((ServerAddress)adr1));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)adr2));
        manager.releasePort("key2");
        Assert.assertFalse((boolean)manager.isInUse((ServerAddress)adr1));
        Assert.assertFalse((boolean)manager.isInUse((ServerAddress)adr2));
    }
}

