/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import java.util.HashMap;
import java.util.Map;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeOperation;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeProperty;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReference;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReferenceElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodelElementContainerBuilder;

public class FakeSubmodelElementCollection
extends FakeElement
implements SubmodelElementCollection {
    private Map<String, SubmodelElement> elements = new HashMap<String, SubmodelElement>();

    protected FakeSubmodelElementCollection(String idShort) {
        super(idShort);
    }

    public void accept(AasVisitor visitor) {
        visitor.visitSubmodelElementCollection((SubmodelElementCollection)this);
        for (SubmodelElement sm : this.elements.values()) {
            sm.accept(visitor);
        }
        visitor.endSubmodelElementCollection((SubmodelElementCollection)this);
    }

    public Iterable<SubmodelElement> elements() {
        return this.elements.values();
    }

    private <T extends SubmodelElement> T filter(String idShort, Class<T> type) {
        SubmodelElement result = null;
        for (SubmodelElement sm : this.elements()) {
            if (!sm.getIdShort().equals(idShort) || !type.isInstance(sm)) continue;
            result = (SubmodelElement)type.cast(sm);
        }
        return (T)result;
    }

    public DataElement getDataElement(String idShort) {
        return this.filter(idShort, DataElement.class);
    }

    public Property getProperty(String idShort) {
        return this.filter(idShort, Property.class);
    }

    public ReferenceElement getReferenceElement(String idShort) {
        return this.filter(idShort, ReferenceElement.class);
    }

    public SubmodelElement getElement(String idShort) {
        return this.elements.get(idShort);
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        return this.filter(idShort, SubmodelElementCollection.class);
    }

    public int getElementsCount() {
        return this.elements.size();
    }

    public Reference createReference() {
        return new FakeReference();
    }

    static class FakeSubmodelElementCollectionBuilder
    extends FakeSubmodelElementContainerBuilder
    implements SubmodelElementCollection.SubmodelElementCollectionBuilder {
        private FakeSubmodelElementContainerBuilder parent;
        private FakeSubmodelElementCollection instance;
        private boolean isNew = true;

        FakeSubmodelElementCollectionBuilder(FakeSubmodelElementContainerBuilder parent, String idShort, boolean ordered, boolean allowDuplicates) {
            this.parent = parent;
            this.instance = new FakeSubmodelElementCollection(idShort);
        }

        FakeSubmodelElementCollectionBuilder(FakeSubmodelElementContainerBuilder parent, FakeSubmodelElementCollection instance) {
            this.parent = parent;
            this.instance = instance;
            this.isNew = false;
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort, boolean ordered, boolean allowDuplicates) {
            return new FakeSubmodelElementCollectionBuilder(this, idShort, ordered, allowDuplicates);
        }

        public Reference createReference() {
            return new FakeReference();
        }

        public SubmodelElementCollection build() {
            this.parent.register(this.instance);
            return this.instance;
        }

        @Override
        FakeOperation register(FakeOperation operation) {
            this.instance.elements.put(operation.getIdShort(), operation);
            return operation;
        }

        @Override
        FakeProperty register(FakeProperty property) {
            this.instance.elements.put(property.getIdShort(), property);
            return property;
        }

        @Override
        FakeReferenceElement register(FakeReferenceElement reference) {
            this.instance.elements.put(reference.getIdShort(), reference);
            return reference;
        }

        @Override
        FakeSubmodelElementCollection register(FakeSubmodelElementCollection collection) {
            this.instance.elements.put(collection.getIdShort(), collection);
            return collection;
        }

        public SubmodelElementContainerBuilder getParentBuilder() {
            return this.parent;
        }

        public Aas.AasBuilder getAasBuilder() {
            return this.parent.getAasBuilder();
        }

        public boolean isNew() {
            return this.isNew;
        }
    }
}

