/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeAas;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeOperation;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeProperty;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReference;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReferenceElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodelElementCollection;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodelElementContainerBuilder;

public class FakeSubmodel
extends FakeElement
implements Submodel {
    private FakeAas parent;
    private Map<String, SubmodelElement> elements = new HashMap<String, SubmodelElement>();

    protected FakeSubmodel(String idShort) {
        super(idShort);
    }

    public void accept(AasVisitor visitor) {
        visitor.visitSubmodel((Submodel)this);
        for (SubmodelElement elt : this.elements.values()) {
            elt.accept(visitor);
        }
        visitor.endSubmodel((Submodel)this);
    }

    public Iterable<SubmodelElement> submodelElements() {
        return this.elements.values();
    }

    public int getSubmodelElementsCount() {
        return this.elements.size();
    }

    private <T extends SubmodelElement> List<T> filter(Class<T> type) {
        ArrayList<SubmodelElement> result = new ArrayList<SubmodelElement>();
        for (SubmodelElement sm : this.submodelElements()) {
            if (!type.isInstance(sm)) continue;
            result.add((SubmodelElement)type.cast(sm));
        }
        return result;
    }

    private <T extends SubmodelElement> T filter(String idShort, Class<T> type) {
        SubmodelElement result = null;
        for (SubmodelElement sm : this.submodelElements()) {
            if (!sm.getIdShort().equals(idShort) || !type.isInstance(sm)) continue;
            result = (SubmodelElement)type.cast(sm);
        }
        return (T)result;
    }

    public Iterable<DataElement> dataElements() {
        return this.filter(DataElement.class);
    }

    public Iterable<Property> properties() {
        return this.filter(Property.class);
    }

    public int getDataElementsCount() {
        return this.filter(DataElement.class).size();
    }

    public Iterable<Operation> operations() {
        return this.filter(Operation.class);
    }

    public int getOperationsCount() {
        return this.filter(Operation.class).size();
    }

    public int getPropertiesCount() {
        return this.filter(Property.class).size();
    }

    public DataElement getDataElement(String idShort) {
        return null;
    }

    public Property getProperty(String idShort) {
        return this.filter(idShort, Property.class);
    }

    public ReferenceElement getReferenceElement(String idShort) {
        return this.filter(idShort, ReferenceElement.class);
    }

    public Operation getOperation(String idShort) {
        return this.filter(idShort, Operation.class);
    }

    public SubmodelElement getSubmodelElement(String idShort) {
        return this.filter(idShort, SubmodelElement.class);
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        return this.filter(idShort, SubmodelElementCollection.class);
    }

    public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort, boolean ordered, boolean allowDuplicates) {
        FakeSubmodelBuilder secb = new FakeSubmodelBuilder(new FakeAas.FakeAasBuilder(this.parent), this);
        return new FakeSubmodelElementCollection.FakeSubmodelElementCollectionBuilder(secb, idShort, ordered, allowDuplicates);
    }

    public Reference createReference() {
        return new FakeReference();
    }

    public void delete(SubmodelElement elt) {
        this.elements.remove(elt.getIdShort());
    }

    static class FakeSubmodelBuilder
    extends FakeSubmodelElementContainerBuilder
    implements Submodel.SubmodelBuilder {
        private FakeAas.FakeAasBuilder parent;
        private FakeSubmodel instance;
        private boolean isNew = true;

        FakeSubmodelBuilder(FakeAas.FakeAasBuilder parent, String idShort) {
            this(parent, idShort, null);
        }

        FakeSubmodelBuilder(FakeAas.FakeAasBuilder parent, String idShort, String identifier) {
            this.parent = parent;
            this.instance = new FakeSubmodel(idShort);
            this.instance.parent = null != parent ? parent.getInstance() : null;
        }

        FakeSubmodelBuilder(FakeAas.FakeAasBuilder parent, FakeSubmodel instance) {
            this.parent = parent;
            this.instance = instance;
            this.isNew = false;
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort, boolean ordered, boolean allowDuplicates) {
            return new FakeSubmodelElementCollection.FakeSubmodelElementCollectionBuilder(this, idShort, ordered, allowDuplicates);
        }

        public Reference createReference() {
            return new FakeReference();
        }

        public Submodel build() {
            return this.parent.register(this.instance);
        }

        @Override
        FakeOperation register(FakeOperation operation) {
            this.instance.elements.put(operation.getIdShort(), operation);
            return operation;
        }

        @Override
        FakeProperty register(FakeProperty property) {
            this.instance.elements.put(property.getIdShort(), property);
            return property;
        }

        @Override
        FakeReferenceElement register(FakeReferenceElement reference) {
            this.instance.elements.put(reference.getIdShort(), reference);
            return reference;
        }

        @Override
        FakeSubmodelElementCollection register(FakeSubmodelElementCollection collection) {
            this.instance.elements.put(collection.getIdShort(), collection);
            return collection;
        }

        public SubmodelElementContainerBuilder getParentBuilder() {
            return null;
        }

        public Aas.AasBuilder getAasBuilder() {
            return this.parent;
        }

        public boolean isNew() {
            return this.isNew;
        }
    }
}

