/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class FactoryTest {
    public static AasFactory createDisabledFactory() {
        return new AasFactory(){

            public String getName() {
                return DUMMY.getName();
            }

            public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String urn) {
                return DUMMY.createSubmodelBuilder(idShort, urn);
            }

            public Server createRegistryServer(Endpoint endpoint, String ... options) {
                return DUMMY.createRegistryServer(endpoint, options);
            }

            public Registry obtainRegistry(Endpoint regEndpoint) throws IOException {
                return DUMMY.obtainRegistry(regEndpoint);
            }

            public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint) {
                return DUMMY.createDeploymentRecipe(endpoint);
            }

            public Aas.AasBuilder createAasBuilder(String idShort, String urn) {
                return DUMMY.createAasBuilder(idShort, urn);
            }

            public PersistenceRecipe createPersistenceRecipe() {
                return DUMMY.createPersistenceRecipe();
            }

            public String[] getProtocols() {
                return DUMMY.getProtocols();
            }

            public InvocablesCreator createInvocablesCreator(String protocol, String host, int port) {
                return DUMMY.createInvocablesCreator(protocol, host, port);
            }

            public ProtocolServerBuilder createProtocolServerBuilder(String protocol, int port) {
                return DUMMY.createProtocolServerBuilder(protocol, port);
            }
        };
    }

    @Test
    public void testFakeFactory() throws IOException {
        AasFactory instance = AasFactory.getInstance();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"fake", (Object)instance.getName());
        Assert.assertNotNull((Object)instance.createAasBuilder("", ""));
        Assert.assertNotNull((Object)instance.createSubmodelBuilder("", ""));
        Endpoint ep = new Endpoint(Schema.HTTP, "", 1234, "");
        Assert.assertNull((Object)instance.createRegistryServer(new Endpoint((ServerAddress)ep, "/registry"), new String[]{""}));
        Assert.assertNull((Object)instance.obtainRegistry(ep));
        Assert.assertNull((Object)instance.createDeploymentRecipe(ep));
        Assert.assertNull((Object)instance.createPersistenceRecipe());
        Assert.assertNotNull((Object)instance.getProtocols());
        Assert.assertTrue((instance.getProtocols().length > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)instance.createInvocablesCreator("", "localhost", 123));
        Assert.assertNull((Object)instance.createProtocolServerBuilder("", 123));
    }

    @Test
    public void testDummyFactory() throws IOException {
        AasFactory old = AasFactory.setInstance((AasFactory)FactoryTest.createDisabledFactory());
        AasFactory instance = AasFactory.getInstance();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)AasFactory.DUMMY.getName(), (Object)instance.getName());
        Assert.assertNull((Object)instance.createAasBuilder("", ""));
        Assert.assertNull((Object)instance.createSubmodelBuilder("", ""));
        Endpoint ep = new Endpoint(Schema.HTTP, "", 1234, "");
        Assert.assertNull((Object)instance.createRegistryServer(new Endpoint((ServerAddress)ep, "/registry"), new String[0]));
        FactoryTest.assertRegistry(instance.obtainRegistry(ep));
        Assert.assertNull((Object)instance.createDeploymentRecipe(ep));
        Assert.assertNull((Object)instance.createPersistenceRecipe());
        Assert.assertNotNull((Object)instance.getProtocols());
        Assert.assertTrue((instance.getProtocols().length > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)instance.createInvocablesCreator("", "localhost", 123));
        Assert.assertNull((Object)instance.createProtocolServerBuilder("", 123));
        AasFactory.setInstance((AasFactory)old);
    }

    private static void assertRegistry(Registry reg) throws IOException {
        Assert.assertNotNull((Object)reg);
        Assert.assertNull((Object)reg.retrieveAas(""));
        reg.createAas(null, "");
        reg.createSubmodel(null, null);
        reg.register(null, null, "");
        Assert.assertNull((Object)reg.retrieveSubmodel("", ""));
    }

    @Test
    public void assertConstants() {
        for (Type type : Type.values()) {
            Assert.assertNotNull((Object)type);
        }
        for (Type type : AssetKind.values()) {
            Assert.assertNotNull((Object)type);
        }
    }
}

