/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentTest {
    @Test
    public void localSubmodelDynamicDeployment() throws IOException {
        String urn = "urn:::AAS:::testMachines#";
        String registryPath = "registry";
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasB = factory.createAasBuilder("myAas", "urn:::AAS:::testMachines#");
        aasB.createSubmodelBuilder("initial", null).build();
        Aas aas = (Aas)aasB.build();
        ServerAddress serverAdr = new ServerAddress(Schema.HTTP);
        AasServer server = factory.createDeploymentRecipe(new Endpoint(serverAdr, "")).addInMemoryRegistry("registry").deploy(aas).createServer(new String[0]).start();
        Endpoint regEp = new Endpoint(serverAdr, "registry");
        Registry reg = factory.obtainRegistry(regEp);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Submodel sub = (Submodel)aas.createSubmodelBuilder("dynamic", null).build();
        server.deploy(aas, sub);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Assert.assertNotNull((Object)aas.getSubmodel("dynamic"));
        server.stop(true);
    }

    @Test
    public void localDynamicSubmodelElementsCollectionDeployment() throws IOException, ExecutionException {
        String urn = "urn:::AAS:::testMachines#";
        ServerAddress serverAddress = new ServerAddress(Schema.HTTP);
        String registryPath = "registry";
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasB = factory.createAasBuilder("myAas", "urn:::AAS:::testMachines#");
        aasB.createSubmodelBuilder("sub", null).build();
        Aas aas = (Aas)aasB.build();
        AasServer server = factory.createDeploymentRecipe(new Endpoint(serverAddress, "")).addInMemoryRegistry("registry").deploy(aas).createServer(new String[0]).start();
        Endpoint regEp = new Endpoint(serverAddress, "registry");
        Registry reg = factory.obtainRegistry(regEp);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Submodel sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcB = sub.createSubmodelElementCollectionBuilder("coll", false, true);
        smcB.createPropertyBuilder("prop").setValue(Type.BOOLEAN, (Object)true).build();
        smcB.build();
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNotNull((Object)coll);
        sub.delete((SubmodelElement)coll);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNull((Object)coll);
        server.stop(true);
    }

    @Test
    public void localDynamicSubmodelElementsCollectionPropertyDeployment() throws IOException, ExecutionException {
        String urn = "urn:::AAS:::testMachines#";
        ServerAddress serverAddress = new ServerAddress(Schema.HTTP);
        String registryPath = "registry";
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasB = factory.createAasBuilder("myAas", "urn:::AAS:::testMachines#");
        aasB.createSubmodelBuilder("sub", null).build();
        Aas aas = (Aas)aasB.build();
        AasServer server = factory.createDeploymentRecipe(new Endpoint(serverAddress, "")).addInMemoryRegistry("registry").deploy(aas).createServer(new String[0]).start();
        Endpoint regEp = new Endpoint(serverAddress, "registry");
        Registry reg = factory.obtainRegistry(regEp);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Submodel sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcB = sub.createSubmodelElementCollectionBuilder("coll", false, false);
        Assert.assertTrue((boolean)smcB.isNew());
        smcB.createPropertyBuilder("prop").setValue(Type.BOOLEAN, (Object)true).build();
        smcB.build();
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNotNull((Object)coll);
        Property prop = coll.getProperty("prop");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)true, (Object)prop.getValue());
        prop.setValue((Object)false);
        Assert.assertEquals((Object)false, (Object)prop.getValue());
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNotNull((Object)coll);
        prop = coll.getProperty("prop");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)false, (Object)prop.getValue());
        server.stop(true);
    }

    @Test
    public void remoteAasDeploymentTest() throws IOException {
        AasFactory factory = AasFactory.getInstance();
        Endpoint regEp = new Endpoint(Schema.HTTP, "registry");
        Server regServer = factory.createRegistryServer(regEp, new String[0]).start();
        Endpoint serverEp = new Endpoint(Schema.HTTP, "cloud");
        DeploymentRecipe.RegistryDeploymentRecipe regD = factory.createDeploymentRecipe(serverEp).setRegistryUrl(regEp);
        Registry reg = regD.obtainRegistry();
        AasServer cloudServer = regD.createServer(new String[0]).start();
        String aasUrn = "urn:::AAS:::oven#";
        Aas.AasBuilder aasB = factory.createAasBuilder("oven", "urn:::AAS:::oven#");
        aasB.createAssetBuilder("OvenAsset", "urn:::AAS:::ovenAsset#", AssetKind.INSTANCE).build();
        Aas aas = (Aas)aasB.build();
        reg.createAas(aas, serverEp.toUri());
        String smUrn = "urn:::AAS:::ovenDoc#";
        Submodel.SubmodelBuilder smB = factory.createSubmodelBuilder("oven_doc", "urn:::AAS:::ovenDoc#");
        smB.createPropertyBuilder("max_temp").setValue((Object)1000).build();
        reg.createSubmodel(aas, (Submodel)smB.build());
        this.assertRemoteAas(regEp, "urn:::AAS:::oven#", "urn:::AAS:::ovenDoc#");
        cloudServer.stop(true);
        regServer.stop(true);
    }

    private void assertRemoteAas(Endpoint regEp, String aasUrn, String smUrn) throws IOException {
        Registry reg = AasFactory.getInstance().obtainRegistry(regEp);
        Aas aas = reg.retrieveAas(aasUrn);
        Assert.assertNotNull((Object)aas);
        Assert.assertEquals((Object)"oven", (Object)aas.getIdShort());
        Submodel sm = reg.retrieveSubmodel(aasUrn, smUrn);
        Assert.assertNotNull((Object)sm);
        Assert.assertEquals((Object)"oven_doc", (Object)sm.getIdShort());
        Assert.assertNotNull((Object)sm.getProperty("max_temp"));
    }
}

