/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.support.aas.TestMachine;

public class AasTest {
    public static final String QNAME_VAR_LOTSIZE;
    public static final String QNAME_VAR_VENDOR;
    public static final String QNAME_VAR_POWCONSUMPTION;
    public static final String QNAME_OP_STARTMACHINE;
    public static final String QNAME_OP_RECONFIGURE;
    public static final String QNAME_OP_STOPMACHINE;
    public static final String NAME_AAS = "aasTest";
    public static final String NAME_SUBMODEL = "machine";
    private static final String NAME_SUBMODELC_OUTER = "outer";
    private static final String NAME_VAR_SUBMODELC_OUTER_VAR = "outerVar";
    private static final String NAME_VAR_SUBMODELC_OUTER_REF = "outerRef";
    private static final String NAME_SUBMODELC_INNER = "inner";
    private static final String NAME_VAR_SUBMODELC_INNER_VAR = "innerVar";
    private static final String NAME_VAR_SUBMODELC_INNER_REF = "innerRef";
    private static final String NAME_VAR_LOTSIZE = "lotSize";
    private static final String NAME_VAR_VENDOR = "vendor";
    private static final String NAME_VAR_POWCONSUMPTION = "powerConsumption";
    private static final String NAME_OP_STARTMACHINE = "startMachine";
    private static final String NAME_OP_RECONFIGURE = "setLotSize";
    private static final String NAME_OP_STOPMACHINE = "stopMachine";
    private static final Logger LOGGER;
    private static final ServerAddress AAS_SERVER;
    private static final Endpoint AAS_SERVER_BASE;
    private static final Endpoint AAS_SERVER_REGISTRY;
    private static final ServerAddress VAB_SERVER;
    private static final String URN_AAS = "urn:::AAS:::testMachines#";

    public static Server createOperationsServer(int port, TestMachine machine) {
        AasFactory factory = AasFactory.getInstance();
        ProtocolServerBuilder builder = factory.createProtocolServerBuilder("", port);
        builder.defineProperty(NAME_VAR_LOTSIZE, () -> machine.getLotSize(), param -> machine.setLotSize((Integer)param));
        builder.defineProperty(NAME_VAR_VENDOR, () -> machine.getVendor(), param -> machine.setVendor((String)param));
        builder.defineProperty(NAME_VAR_POWCONSUMPTION, () -> machine.getPowerConsumption(), null);
        builder.defineOperation(NAME_OP_STARTMACHINE, params -> {
            machine.start();
            return null;
        });
        builder.defineOperation(NAME_OP_RECONFIGURE, params -> machine.reconfigure((Integer)params[0]));
        builder.defineOperation(NAME_OP_STOPMACHINE, params -> {
            machine.stop();
            return null;
        });
        return (Server)builder.build();
    }

    public static void createAasOperationsElements(SubmodelElementContainerBuilder subModelBuilder, ServerAddress addr) {
        AasTest.createAasOperationsElements(subModelBuilder, addr.getHost(), addr.getPort());
    }

    public static void createAasOperationsElements(SubmodelElementContainerBuilder subModelBuilder, String host, int port) {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator invC = factory.createInvocablesCreator("", host, port);
        subModelBuilder.createPropertyBuilder(NAME_VAR_LOTSIZE).setType(Type.INTEGER).bind(invC.createGetter(NAME_VAR_LOTSIZE), invC.createSetter(NAME_VAR_LOTSIZE)).build();
        subModelBuilder.createPropertyBuilder(NAME_VAR_VENDOR).setType(Type.STRING).bind(invC.createGetter(NAME_VAR_VENDOR), invC.createSetter(NAME_VAR_VENDOR)).build();
        subModelBuilder.createPropertyBuilder(NAME_VAR_POWCONSUMPTION).setType(Type.DOUBLE).bind(invC.createGetter(NAME_VAR_POWCONSUMPTION), null).build();
        subModelBuilder.createOperationBuilder(NAME_OP_STARTMACHINE).setInvocable(invC.createInvocable(NAME_OP_STARTMACHINE)).build();
        subModelBuilder.createOperationBuilder(NAME_OP_RECONFIGURE).addInputVariable(NAME_VAR_LOTSIZE, Type.INTEGER).setInvocable(invC.createInvocable(NAME_OP_RECONFIGURE)).build();
        subModelBuilder.createOperationBuilder(NAME_OP_STOPMACHINE).setInvocable(invC.createInvocable(NAME_OP_STOPMACHINE)).build();
    }

    @Test
    public void testVabQuery() throws SocketException, UnknownHostException, ExecutionException, IOException {
        TestMachine machine = new TestMachine();
        Server ccServer = AasTest.createOperationsServer(VAB_SERVER.getPort(), machine);
        ccServer.start();
        Aas aas = AasTest.createAas(machine);
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe(AAS_SERVER_BASE).addInMemoryRegistry(AAS_SERVER_REGISTRY.getEndpoint()).deploy(aas).createServer(new String[0]).start();
        AasTest.queryAas(machine);
        httpServer.stop(true);
        ccServer.stop(true);
    }

    private static Aas createAas(TestMachine machine) throws SocketException, UnknownHostException {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(NAME_AAS, URN_AAS);
        Submodel.SubmodelBuilder subModelBuilder = aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null);
        Assert.assertTrue((boolean)subModelBuilder.isNew());
        AasTest.createAasOperationsElements((SubmodelElementContainerBuilder)subModelBuilder, VAB_SERVER);
        Reference subModelBuilderRef = subModelBuilder.createReference();
        Assert.assertNotNull((Object)aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null));
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcBuilderOuter = subModelBuilder.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_OUTER, false, true);
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcBuilderInner = smcBuilderOuter.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_INNER, false, true);
        smcBuilderInner.createPropertyBuilder(NAME_VAR_SUBMODELC_INNER_VAR).setType(Type.INTEGER).build();
        ReferenceElement re = (ReferenceElement)smcBuilderInner.createReferenceElementBuilder(NAME_VAR_SUBMODELC_INNER_REF).setValue(subModelBuilderRef).build();
        Assert.assertNotNull((Object)re.getValue());
        Assert.assertTrue((boolean)re.getValue().hasReference());
        Reference smcBuilder1Ref = smcBuilderInner.createReference();
        smcBuilderInner.build();
        smcBuilderOuter.createPropertyBuilder(NAME_VAR_SUBMODELC_OUTER_VAR).setType(Type.STRING).build();
        smcBuilderOuter.createReferenceElementBuilder(NAME_VAR_SUBMODELC_OUTER_REF).setValue(smcBuilder1Ref).build();
        SubmodelElementCollection smcOuter = (SubmodelElementCollection)smcBuilderOuter.build();
        AasTest.assertSize(3, smcOuter.elements());
        Assert.assertEquals((long)3L, (long)smcOuter.getElementsCount());
        Assert.assertNotNull((Object)smcOuter.getDataElement(NAME_VAR_SUBMODELC_OUTER_VAR));
        Assert.assertNotNull((Object)smcOuter.getElement(NAME_SUBMODELC_INNER));
        Assert.assertNotNull((Object)subModelBuilder.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_OUTER, false, true));
        Submodel submodel = (Submodel)subModelBuilder.build();
        AasTest.assertSize(3, submodel.operations());
        AasTest.assertSize(0, submodel.dataElements());
        AasTest.assertSize(3, submodel.properties());
        AasTest.assertSize(7, submodel.submodelElements());
        Assert.assertNotNull((Object)submodel.getOperation(NAME_OP_RECONFIGURE));
        Assert.assertEquals((long)7L, (long)submodel.getSubmodelElementsCount());
        Assert.assertNull((Object)submodel.getReferenceElement("myRef"));
        Aas aas = (Aas)aasBuilder.build();
        Submodel subAdd = (Submodel)aas.createSubmodelBuilder("sub_add", null).build();
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add"));
        subAdd.createSubmodelElementCollectionBuilder("sub_coll", true, true).build();
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add").getSubmodelElementCollection("sub_coll"));
        submodel.createSubmodelElementCollectionBuilder("sub_coll2", false, false).build();
        Assert.assertNotNull((Object)submodel.getSubmodelElementCollection("sub_coll2"));
        aas.accept((AasVisitor)new AasPrintVisitor());
        return aas;
    }

    private static void queryAas(TestMachine machine) throws ExecutionException, IOException {
        AasFactory factory = AasFactory.getInstance();
        Aas aas = factory.obtainRegistry(AAS_SERVER_REGISTRY).retrieveAas(URN_AAS);
        Assert.assertEquals((Object)NAME_AAS, (Object)aas.getIdShort());
        Assert.assertEquals((long)2L, (long)aas.getSubmodelCount());
        Submodel submodel = (Submodel)aas.submodels().iterator().next();
        Assert.assertNotNull((Object)submodel);
        Assert.assertEquals((long)3L, (long)submodel.getPropertiesCount());
        Property lotSize = submodel.getProperty(NAME_VAR_LOTSIZE);
        Assert.assertNotNull((Object)lotSize);
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Property powConsumption = submodel.getProperty(NAME_VAR_POWCONSUMPTION);
        Assert.assertNotNull((Object)powConsumption);
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        Assert.assertEquals((long)3L, (long)submodel.getOperationsCount());
        Operation op = submodel.getOperation(NAME_OP_STARTMACHINE);
        Assert.assertNotNull((Object)op);
        op.invoke(new Object[0]);
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        op = submodel.getOperation(NAME_OP_RECONFIGURE);
        Assert.assertNotNull((Object)op);
        op.invoke(new Object[]{5});
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        op = submodel.getOperation(NAME_OP_STOPMACHINE);
        Assert.assertNotNull((Object)op);
        op.invoke(new Object[0]);
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        SubmodelElement se = submodel.getSubmodelElement(NAME_SUBMODELC_OUTER);
        Assert.assertNotNull((Object)se);
        Assert.assertTrue((boolean)(se instanceof SubmodelElementCollection));
        SubmodelElementCollection secOuter = submodel.getSubmodelElementCollection(NAME_SUBMODELC_OUTER);
        Assert.assertNotNull((Object)secOuter);
        Assert.assertTrue((se == secOuter ? 1 : 0) != 0);
        Assert.assertNotNull((Object)secOuter.getProperty(NAME_VAR_SUBMODELC_OUTER_VAR));
        Assert.assertNotNull((Object)secOuter.getReferenceElement(NAME_VAR_SUBMODELC_OUTER_REF));
        SubmodelElementCollection secInner = secOuter.getSubmodelElementCollection(NAME_SUBMODELC_INNER);
        Assert.assertNotNull((Object)secInner);
        Assert.assertNotNull((Object)secInner.getProperty(NAME_VAR_SUBMODELC_INNER_VAR));
        Assert.assertNotNull((Object)secInner.getReferenceElement(NAME_VAR_SUBMODELC_INNER_REF));
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add"));
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add").getSubmodelElementCollection("sub_coll"));
        Assert.assertNotNull((Object)submodel.getSubmodelElementCollection("sub_coll2"));
        Submodel subAdd = (Submodel)aas.createSubmodelBuilder("conn_add", null).build();
        Assert.assertNotNull((Object)aas.getSubmodel("conn_add"));
        subAdd.createSubmodelElementCollectionBuilder("conn_coll", true, true).build();
        Assert.assertNotNull((Object)aas.getSubmodel("conn_add").getSubmodelElementCollection("conn_coll"));
        submodel.createSubmodelElementCollectionBuilder("conn_coll2", false, false).build();
        Assert.assertNotNull((Object)submodel.getSubmodelElementCollection("conn_coll2"));
        aas.accept((AasVisitor)new AasPrintVisitor());
    }

    private static <T> void assertSize(int expectedSize, Iterable<T> iter) {
        Assert.assertEquals((long)expectedSize, (long)CollectionUtils.toList(iter.iterator()).size());
    }

    @Test
    public void testFactory() {
        Assert.assertTrue((AasFactory.getInstance().getName().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIllegalShortId() {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(NAME_AAS, URN_AAS);
        Submodel.SubmodelBuilder subModelBuilder = aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null);
        try {
            subModelBuilder.createPropertyBuilder("value").setValue((Object)1).build();
            Assert.fail((String)"No exception due to illegal name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            subModelBuilder.createPropertyBuilder("1234").setValue((Object)1).build();
            Assert.fail((String)"No exception due to illegal name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            subModelBuilder.createPropertyBuilder("java.lang.String").setValue((Object)1).build();
            Assert.fail((String)"No exception due to illegal name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(AasTest.class);
        AAS_SERVER = new ServerAddress(Schema.HTTP);
        AAS_SERVER_BASE = new Endpoint(AAS_SERVER, "");
        AAS_SERVER_REGISTRY = new Endpoint(AAS_SERVER, "registry");
        VAB_SERVER = new ServerAddress(Schema.HTTP);
        QNAME_VAR_LOTSIZE = "machine/lotSize";
        QNAME_VAR_VENDOR = "machine/vendor";
        QNAME_VAR_POWCONSUMPTION = "machine/powerConsumption";
        QNAME_OP_STARTMACHINE = "machine/startMachine";
        QNAME_OP_RECONFIGURE = "machine/setLotSize";
        QNAME_OP_STOPMACHINE = "machine/stopMachine";
    }
}

