/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUtilsTest {
    @Test
    public void testToList() {
        ArrayList<String> data = new ArrayList<String>();
        List result = CollectionUtils.toList(data.iterator());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        data.add("HERE");
        data.add("There");
        result = CollectionUtils.toList(data.iterator());
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)data.size(), (long)result.size());
        Assert.assertEquals(data, (Object)result);
    }

    @Test
    public void testToSet() {
        ArrayList<String> data = new ArrayList<String>();
        Set result = CollectionUtils.toSet(data.iterator());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        data.add("HERE");
        data.add("There");
        result = CollectionUtils.toSet(data.iterator());
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)data.size(), (long)result.size());
        for (String s : data) {
            Assert.assertTrue((boolean)result.contains(s));
        }
    }

    @Test
    public void testToListVarArg() {
        List tmp = CollectionUtils.toList((Object[])new String[0]);
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)0L, (long)tmp.size());
        tmp = CollectionUtils.toList((Object[])new String[]{"a"});
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)1L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        tmp = CollectionUtils.toList((Object[])new String[]{"a", "b"});
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)2L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        Assert.assertEquals((Object)"b", tmp.get(1));
    }

    @Test
    public void testAddAllVarArg() {
        ArrayList tmp = new ArrayList();
        List res = CollectionUtils.addAll(tmp, (Object[])new String[0]);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.size());
        res = CollectionUtils.addAll(tmp, (Object[])new String[]{"a"});
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        res = CollectionUtils.addAll(tmp, (Object[])new String[]{"a", "b"});
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        Assert.assertEquals((Object)"a", tmp.get(1));
        Assert.assertEquals((Object)"b", tmp.get(2));
    }
}

