/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.types.technicaldata;

import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxFile;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.GeneralInformation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.types.technicaldata.submodelelementcollections.generalinformation.GeneralInformation;

public class BaSyxGeneralInformation
extends BaSyxSubmodelElementCollection
implements de.iip_ecosphere.platform.support.aas.types.technicaldata.GeneralInformation {
    public static final String ID_SHORT = "GeneralInformation";

    private BaSyxGeneralInformation() {
    }

    BaSyxGeneralInformation(GeneralInformation collection) {
        super((ISubmodelElementCollection)collection);
    }

    public GeneralInformation getSubmodelElement() {
        return (GeneralInformation)super.getSubmodelElement();
    }

    public String getManufacturerName() {
        return (String)this.getSubmodelElement().getManufacturerName().getValue();
    }

    public List<LangString> getManufacturerProductDesignation() {
        LangStrings ls = this.getSubmodelElement().getManufacturerProductDesignation().getValue();
        ArrayList<LangString> result = new ArrayList<LangString>();
        for (org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString l : ls) {
            result.add(Tools.translate(l));
        }
        return result;
    }

    public String getManufacturerPartNumber() {
        return (String)this.getSubmodelElement().getManufacturerPartNumber().getValue();
    }

    public String getManufacturerOrderCode() {
        return (String)this.getSubmodelElement().getManufacturerOrderCode().getValue();
    }

    public FileDataElement getManufacturerLogo() {
        return (FileDataElement)this.getDataElement("ManufacturerLogo");
    }

    public Iterable<FileDataElement> getProductImages() {
        return this.getElements(s -> s.getIdShort().startsWith("ProductImage"), FileDataElement.class);
    }

    public static class BaSyxGeneralInformationBuilder
    extends BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder
    implements GeneralInformation.GeneralInformationBuilder {
        private List<BaSyxFile> productImages;
        private BaSyxFile manufacturerLogo;

        BaSyxGeneralInformationBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String manufacturerName, LangString manufacturerProductDesignation, String manufacturerPartNumber, String manufacturerOrderCode) {
            super(parentBuilder, BaSyxGeneralInformation.ID_SHORT, () -> new BaSyxGeneralInformation(), () -> new GeneralInformation(manufacturerName, Tools.translate(manufacturerProductDesignation), manufacturerPartNumber, manufacturerOrderCode));
        }

        BaSyxGeneralInformationBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, BaSyxSubmodelElementCollection instance) {
            super(parentBuilder, instance);
        }

        @Override
        public BaSyxSubmodelElementCollection build() {
            GeneralInformation gi = (GeneralInformation)this.getCollection();
            if (null != this.productImages) {
                ArrayList<File> tmp = new ArrayList<File>();
                for (BaSyxFile f : this.productImages) {
                    this.getCollectionInstance().register(f);
                    tmp.add((File)f.getDataElement());
                }
                gi.setProductImages(tmp);
            }
            if (null != this.manufacturerLogo) {
                this.getCollectionInstance().register(this.manufacturerLogo);
                gi.setManufacturerLogo((File)this.manufacturerLogo.getDataElement());
            }
            return super.build();
        }

        public GeneralInformation.GeneralInformationBuilder addProductImageFile(String name, String file, String mimeType) {
            if (null == this.productImages) {
                this.productImages = new ArrayList<BaSyxFile>();
            }
            this.productImages.add(new BaSyxFile("ProductImage" + name, file, mimeType));
            return this;
        }

        public GeneralInformation.GeneralInformationBuilder setManufacturerLogo(String file, String mimeType) {
            this.manufacturerLogo = new BaSyxFile("ManufacturerLogo", file, mimeType);
            return this;
        }
    }
}

