/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.basyx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.eclipse.basyx.vab.coder.json.provider.JSONProvider;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.basyx.CoderTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VABBaSyxTCPInterface<ModelProvider extends IModelProvider>
extends Thread {
    public static final byte BASYX_GET = 1;
    public static final byte BASYX_SET = 2;
    public static final byte BASYX_CREATE = 3;
    public static final byte BASYX_DELETE = 4;
    public static final byte BASYX_INVOKE = 5;
    public static final byte BASYX_RESULT_OK = 0;
    private static Logger logger = LoggerFactory.getLogger(VABBaSyxTCPInterface.class);
    protected JSONProvider<ModelProvider> providerBackend = null;
    protected SocketChannel commChannel = null;

    public VABBaSyxTCPInterface(ModelProvider modelProviderBackend, SocketChannel channel) {
        this.providerBackend = new JSONProvider(modelProviderBackend);
        this.commChannel = channel;
        this.setName(VABBaSyxTCPInterface.class.getName() + " " + System.currentTimeMillis());
        logger.debug("Socket created");
    }

    public void processInputFrame(byte[] rxFrame) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        switch (rxFrame[0]) {
            case 1: {
                int pathLen = CoderTools.getInt32((byte[])rxFrame, (int)1);
                String path = new String(rxFrame, 5, pathLen);
                try {
                    this.providerBackend.processBaSysGet(path, (OutputStream)output);
                }
                catch (ProviderException e) {
                    logger.debug("Exception in BASYX_GET", (Throwable)e);
                }
                output.flush();
                this.sendResponseFrame(output);
                break;
            }
            case 2: {
                int pathLen = CoderTools.getInt32((byte[])rxFrame, (int)1);
                String path = new String(rxFrame, 5, pathLen);
                int jsonValueLen = CoderTools.getInt32((byte[])rxFrame, (int)(5 + pathLen));
                String jsonValue = new String(rxFrame, 5 + pathLen + 4, jsonValueLen);
                try {
                    this.providerBackend.processBaSysSet(path, jsonValue, (OutputStream)output);
                }
                catch (ProviderException e) {
                    logger.debug("Exception in BASYX_SET", (Throwable)e);
                }
                output.flush();
                this.sendResponseFrame(output);
                break;
            }
            case 3: {
                int pathLen = CoderTools.getInt32((byte[])rxFrame, (int)1);
                String path = new String(rxFrame, 5, pathLen);
                int jsonValueLen = CoderTools.getInt32((byte[])rxFrame, (int)(5 + pathLen));
                String jsonValue = new String(rxFrame, 5 + pathLen + 4, jsonValueLen);
                try {
                    this.providerBackend.processBaSysCreate(path, jsonValue, (OutputStream)output);
                }
                catch (ProviderException e) {
                    logger.debug("Exception in BASYX_CREATE", (Throwable)e);
                }
                output.flush();
                this.sendResponseFrame(output);
                break;
            }
            case 4: {
                int pathLen = CoderTools.getInt32((byte[])rxFrame, (int)1);
                String path = new String(rxFrame, 5, pathLen);
                String jsonValue = "";
                try {
                    int jsonValueLen = CoderTools.getInt32((byte[])rxFrame, (int)(5 + pathLen));
                    jsonValue = new String(rxFrame, 5 + pathLen + 4, jsonValueLen);
                }
                catch (ArrayIndexOutOfBoundsException jsonValueLen) {
                    // empty catch block
                }
                try {
                    this.providerBackend.processBaSysDelete(path, jsonValue, (OutputStream)output);
                }
                catch (ProviderException e) {
                    logger.debug("Exception in BASYX_DELETE", (Throwable)e);
                }
                output.flush();
                this.sendResponseFrame(output);
                break;
            }
            case 5: {
                int pathLen = CoderTools.getInt32((byte[])rxFrame, (int)1);
                String path = new String(rxFrame, 5, pathLen);
                int jsonValueLen = CoderTools.getInt32((byte[])rxFrame, (int)(5 + pathLen));
                String jsonValue = new String(rxFrame, 5 + pathLen + 4, jsonValueLen);
                try {
                    this.providerBackend.processBaSysInvoke(path, jsonValue, (OutputStream)output);
                }
                catch (ProviderException e) {
                    logger.debug("Exception in BASYX_INVOKE", (Throwable)e);
                }
                output.flush();
                this.sendResponseFrame(output);
                break;
            }
            default: {
                throw new RuntimeException("Unknown BaSyx TCP command received");
            }
        }
    }

    private void sendResponseFrame(ByteArrayOutputStream byteArrayOutput) throws IOException {
        this.sendResponseFrame(byteArrayOutput, 0);
    }

    private void sendResponseFrame(ByteArrayOutputStream byteArrayOutput, int result) throws IOException {
        byte[] encodedResult = byteArrayOutput.toByteArray();
        int resultFrameSize = encodedResult.length + 1;
        byte[] frameLength = new byte[4];
        byte[] encodedResultLength = new byte[4];
        CoderTools.setInt32((byte[])frameLength, (int)0, (int)(resultFrameSize + 4));
        CoderTools.setInt32((byte[])encodedResultLength, (int)0, (int)encodedResult.length);
        ByteBuffer buffer = ByteBuffer.allocate(resultFrameSize + 4 + 4);
        buffer.put(frameLength);
        buffer.put((byte)result);
        buffer.put(encodedResultLength);
        buffer.put(encodedResult);
        ((Buffer)buffer).flip();
        this.commChannel.write(buffer);
        byteArrayOutput.reset();
    }

    protected void readBytes(ByteBuffer bytes, int expectedBytes) throws IOException {
        while (bytes.position() < expectedBytes) {
            int res = this.commChannel.read(bytes);
            if (res != -1) continue;
            throw new ClosedChannelException();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ByteBuffer rxBuffer1 = ByteBuffer.allocate(4);
                    this.readBytes(rxBuffer1, 4);
                    int frameSize = CoderTools.getInt32((byte[])rxBuffer1.array(), (int)0);
                    logger.debug("Read Frame with size: " + frameSize);
                    ByteBuffer rxBuffer2 = ByteBuffer.allocate(frameSize);
                    this.readBytes(rxBuffer2, frameSize);
                    byte[] rxFrame = rxBuffer2.array();
                    this.processInputFrame(rxFrame);
                }
            }
            catch (IOException e) {
                if (!(e instanceof ClosedChannelException)) {
                    logger.error("Exception in run", (Throwable)e);
                    continue;
                }
                try {
                    this.commChannel.close();
                }
                catch (IOException e2) {
                    logger.debug("Exception while closing the comChannel ", (Throwable)e2);
                }
                logger.debug(this.getName() + " Socket closed");
                return;
            }
            break;
        }
    }
}

