/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.basyx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.eclipse.basyx.vab.protocol.basyx.CoderTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaSyxConnector
implements IBaSyxConnector {
    private Logger logger = LoggerFactory.getLogger(BaSyxConnector.class);
    private InetSocketAddress serverSocketAddress;
    private SocketChannel channelToProvider;
    private boolean keepOpen = false;

    public BaSyxConnector(String hostName, int port) {
        this(hostName, port, false);
    }

    public BaSyxConnector(String hostName, int port, boolean keepOpen) {
        this.keepOpen = keepOpen;
        try {
            InetAddress serverIPAddress = InetAddress.getByName(hostName);
            this.serverSocketAddress = new InetSocketAddress(serverIPAddress, port);
        }
        catch (IOException e) {
            this.logger.error("Exception in BaSyxConnector: " + e.getMessage());
        }
    }

    private void closeConnection() {
        try {
            this.channelToProvider.close();
        }
        catch (IOException e) {
            this.logger.error("Exception in closeConnection: " + e.getMessage());
        }
    }

    protected synchronized String invokeBaSyx(byte[] call) {
        try {
            ByteBuffer txBuffer = ByteBuffer.wrap(call);
            if (!this.keepOpen || this.keepOpen && this.channelToProvider == null) {
                this.channelToProvider = SocketChannel.open();
                this.channelToProvider.configureBlocking(true);
                this.channelToProvider.connect(this.serverSocketAddress);
            }
            this.channelToProvider.write(txBuffer);
            ByteBuffer rxBuffer1 = ByteBuffer.allocate(4);
            this.readBytes(rxBuffer1, 4);
            int frameSize = CoderTools.getInt32((byte[])rxBuffer1.array(), (int)0);
            ByteBuffer rxBuffer2 = ByteBuffer.allocate(frameSize);
            this.readBytes(rxBuffer2, frameSize);
            byte[] rxFrame = rxBuffer2.array();
            if (rxFrame == null || rxFrame.length < 2) {
                return null;
            }
            int jsonResultLen = CoderTools.getInt32((byte[])rxFrame, (int)1);
            String jsonResult = new String(rxFrame, 5, jsonResultLen);
            if (!this.keepOpen) {
                this.closeConnection();
            }
            return jsonResult.toString();
        }
        catch (IOException e) {
            this.logger.error("Exception in invokeBaSyx: " + e.getMessage());
            return null;
        }
    }

    protected void readBytes(ByteBuffer bytes, int expectedBytes) {
        try {
            while (bytes.position() < expectedBytes) {
                this.channelToProvider.read(bytes);
            }
        }
        catch (IOException e) {
            this.logger.error("Exception in readBytes: " + e.getMessage());
        }
    }

    public String getValue(String servicePath) {
        byte[] call = this.createCall(servicePath, (byte)1);
        return this.invokeBaSyx(call);
    }

    public String setValue(String servicePath, String newValue) {
        byte[] call = this.createCall(servicePath, newValue, (byte)2);
        return this.invokeBaSyx(call);
    }

    public String createValue(String servicePath, String newValue) throws ProviderException {
        byte[] call = this.createCall(servicePath, newValue, (byte)3);
        return this.invokeBaSyx(call);
    }

    public String invokeOperation(String servicePath, String parameters) throws ProviderException {
        byte[] call = this.createCall(servicePath, parameters, (byte)5);
        return this.invokeBaSyx(call);
    }

    public String deleteValue(String servicePath) throws ProviderException {
        byte[] call = this.createCall(servicePath, (byte)4);
        return this.invokeBaSyx(call);
    }

    public String deleteValue(String servicePath, String jsonObject) throws ProviderException {
        byte[] call = this.createCall(servicePath, jsonObject, (byte)4);
        return this.invokeBaSyx(call);
    }

    private byte[] createCall(String servicePath, byte callType) {
        byte[] call = new byte[9 + servicePath.length()];
        CoderTools.setInt32((byte[])call, (int)0, (int)(call.length - 4));
        CoderTools.setInt8((byte[])call, (int)4, (int)callType);
        CoderTools.setInt32((byte[])call, (int)5, (int)servicePath.length());
        CoderTools.setString((byte[])call, (int)9, (String)servicePath);
        return call;
    }

    private byte[] createCall(String servicePath, String newValue, byte callType) {
        byte[] call = new byte[9 + servicePath.length() + 4 + newValue.length()];
        CoderTools.setInt32((byte[])call, (int)0, (int)(call.length - 4));
        CoderTools.setInt8((byte[])call, (int)4, (int)callType);
        CoderTools.setInt32((byte[])call, (int)5, (int)servicePath.length());
        CoderTools.setString((byte[])call, (int)9, (String)servicePath);
        CoderTools.setInt32((byte[])call, (int)(9 + servicePath.length()), (int)newValue.length());
        CoderTools.setString((byte[])call, (int)(9 + servicePath.length() + 4), (String)newValue);
        return call;
    }

    public String getEndpointRepresentation(String path) {
        return "basyx://" + this.serverSocketAddress.getHostString() + ":" + this.serverSocketAddress.getPort() + "/" + path;
    }
}

