/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxVABTCPPayloadCodec;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.basyx.BaSyxTCPServer;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServlet;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.generic.IVABElementHandler;
import org.eclipse.basyx.vab.modelprovider.generic.VABModelProvider;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxHTTPServer;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;
import org.slf4j.LoggerFactory;

public class VabOperationsProvider
extends HashMap<String, Object>
implements OperationsProvider {
    public static final String SEPARATOR = "/";
    public static final String STATUS = "status";
    public static final String PREFIX_STATUS = "status/";
    public static final String OPERATIONS = "operations";
    public static final String PREFIX_OPERATIONS = "operations/";
    public static final String SERVICE = "service";
    public static final String PREFIX_SERVICE = "operations/service/";
    private static final long serialVersionUID = 6355197555283292724L;
    private Map<String, Entry> status = new HashMap<String, Entry>();
    private Map<String, Map<String, Entry>> operations = new HashMap<String, Map<String, Entry>>();
    private Map<String, Entry> service = new HashMap<String, Entry>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<String, Function<Object[], Object>> operationFunctions = new HashMap<String, Function<Object[], Object>>();

    public VabOperationsProvider() {
        this.put(this.getStatusPath(), this.status);
        this.put(this.getOperationsPath(), this.operations);
        this.operations.put(this.getServicePath(), this.service);
    }

    protected String getStatusPath() {
        return STATUS;
    }

    protected String getOperationsPath() {
        return OPERATIONS;
    }

    protected String getServicePath() {
        return SERVICE;
    }

    public VABModelProvider createModelProvider() {
        return new VABModelProvider((Object)this, (IVABElementHandler)new VABElementHandler());
    }

    private String makeUnique(Map<String, ?> map, String baseName) {
        Object uName = baseName;
        int pos = 1;
        while (this.operationFunctions.containsKey(uName)) {
            uName = baseName + "_" + pos;
            ++pos;
        }
        return uName;
    }

    public VabOperationsProvider defineOperation(String category, String name, Function<Object[], Object> function) {
        String uName = this.makeUnique(this.operationFunctions, category + SEPARATOR + name);
        Map<String, Entry> o = this.operations.get(category);
        if (null == o) {
            o = new HashMap<String, Entry>();
            this.operations.put(category, o);
        }
        o.put(name, new Entry(Kind.OPERATION, uName));
        this.operationFunctions.put(uName, function);
        LoggerFactory.getLogger(this.getClass()).info("Operation " + category + SEPARATOR + name + " defined (uname " + uName + ")");
        return this;
    }

    public Function<Object[], Object> getOperation(String category, String name) {
        Function<Object[], Object> result = null;
        Map<String, Entry> cat = this.operations.get(category);
        if (null != cat) {
            Entry ent = cat.get(name);
            if (Kind.OPERATION == ent.kind) {
                result = this.operationFunctions.get(ent.uName);
            }
        }
        return result;
    }

    public Function<Object[], Object> getServiceFunction(String name) {
        return this.getOperation(this.getServicePath(), name);
    }

    public VabOperationsProvider defineServiceFunction(String name, Function<Object[], Object> function) {
        return this.defineOperation(this.getServicePath(), name, (Function)function);
    }

    public VabOperationsProvider defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
        this.properties.put(name, new Property(get, set));
        this.status.put(name, new Entry(Kind.PROPERTY, name));
        LoggerFactory.getLogger(this.getClass()).info("Property " + name + " defined");
        return this;
    }

    public Supplier<Object> getGetter(String name) {
        Property prop = this.properties.get(name);
        return null == prop ? null : prop.get;
    }

    public Consumer<Object> getSetter(String name) {
        Property prop = this.properties.get(name);
        return null == prop ? null : prop.set;
    }

    private class VABElementHandler
    implements IVABElementHandler {
        private VABElementHandler() {
        }

        public Object postprocessObject(Object element) {
            Object result = element;
            if (element instanceof Property) {
                result = ((Property)element).get.get();
            }
            return result;
        }

        public Object getElementProperty(Object element, String propertyName) {
            Map map = (Map)element;
            Object result = map.get(propertyName);
            if (result instanceof Entry) {
                Entry entry = (Entry)result;
                switch (entry.kind) {
                    case PROPERTY: {
                        result = VabOperationsProvider.this.properties.get(entry.uName);
                        break;
                    }
                    case OPERATION: {
                        result = VabOperationsProvider.this.operationFunctions.get(entry.uName);
                        break;
                    }
                    default: {
                        throw new ResourceNotFoundException("Unkown entry kind for " + propertyName);
                    }
                }
                if (null == result) {
                    throw new ResourceNotFoundException(entry.kind.name().toLowerCase() + propertyName + " not found.");
                }
            }
            return result;
        }

        public void setModelPropertyValue(Object element, String propertyName, Object newValue) {
            Property prop = VabOperationsProvider.this.properties.get(propertyName);
            if (null == prop) {
                throw new ResourceNotFoundException("Property " + propertyName + " not found.");
            }
            if (null == prop.set) {
                throw new ResourceNotFoundException("Property " + propertyName + " not found (for reading).");
            }
            prop.set.accept(newValue);
        }

        public void createValue(Object element, Object newValue) {
            throw new ResourceNotFoundException("Element " + element + " not supported.");
        }

        public void deleteValue(Object element, String propertyName) {
            throw new ResourceNotFoundException("Element " + element + " not supported.");
        }

        public void deleteValue(Object element, Object property) {
            throw new ResourceNotFoundException("Element " + element + " not found.");
        }
    }

    static class VabHttpOperationsBuilder
    implements ProtocolServerBuilder {
        private int port;
        private Schema schema;
        private VabOperationsProvider instance;
        private KeyStoreDescriptor kstore;

        VabHttpOperationsBuilder(int port, Schema schema, KeyStoreDescriptor kstore) {
            this.port = port;
            this.instance = new VabOperationsProvider();
            this.kstore = kstore;
        }

        public ProtocolServerBuilder defineOperation(String name, Function<Object[], Object> function) {
            this.instance.defineServiceFunction(name, (Function)function);
            return this;
        }

        public ProtocolServerBuilder defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
            this.instance.defineProperty(name, (Supplier)get, (Consumer)set);
            return this;
        }

        public Server build() {
            Endpoint endpoint = new Endpoint(this.schema, this.port, "");
            VABHTTPInterface vabServlet = new VABHTTPInterface((IModelProvider)this.instance.createModelProvider());
            DeploymentSpec deploymentSpec = new DeploymentSpec(endpoint, this.kstore);
            deploymentSpec.getContext().addServletMapping(Endpoint.checkEndpoint((String)endpoint.getEndpoint()) + "/*", (HttpServlet)vabServlet);
            final BaSyxHTTPServer server = new BaSyxHTTPServer(deploymentSpec.getContext());
            Server result = new Server(){

                public Server start() {
                    server.start();
                    return this;
                }

                public void stop(boolean dispose) {
                    server.shutdown();
                }
            };
            return result;
        }

        public ProtocolServerBuilder.PayloadCodec createPayloadCodec() {
            return new BaSyxVABTCPPayloadCodec();
        }

        public boolean isAvailable(String host) {
            return NetUtils.isAvailable((String)host, (int)this.port);
        }
    }

    static class VabTcpOperationsBuilder
    implements ProtocolServerBuilder {
        private int port;
        private VabOperationsProvider instance;

        VabTcpOperationsBuilder(int port) {
            this.port = port;
            this.instance = new VabOperationsProvider();
        }

        public VabTcpOperationsBuilder defineOperation(String name, Function<Object[], Object> function) {
            this.instance.defineServiceFunction(name, (Function)function);
            return this;
        }

        public VabTcpOperationsBuilder defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
            this.instance.defineProperty(name, (Supplier)get, (Consumer)set);
            return this;
        }

        public Server build() {
            System.out.println("Starting VAB server on " + this.port);
            final BaSyxTCPServer<VABModelProvider> server = new BaSyxTCPServer<VABModelProvider>(this.instance.createModelProvider(), this.port);
            Server result = new Server(){

                public Server start() {
                    server.start();
                    return this;
                }

                public void stop(boolean dispose) {
                    server.stop();
                }
            };
            return result;
        }

        public ProtocolServerBuilder.PayloadCodec createPayloadCodec() {
            return new BaSyxVABTCPPayloadCodec();
        }

        public boolean isAvailable(String host) {
            return NetUtils.isAvailable((String)host, (int)this.port);
        }
    }

    private static class Property {
        private Consumer<Object> set;
        private Supplier<Object> get;

        private Property(Supplier<Object> get, Consumer<Object> set) {
            this.set = set;
            this.get = get;
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 3003478232778729891L;
        private Kind kind;
        private String uName;

        private Entry(Kind kind, String uName) {
            this.kind = kind;
            this.uName = uName;
        }
    }

    private static enum Kind {
        PROPERTY,
        OPERATION;

    }
}

