/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.basyx.BaSyxHTTPSConnector;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxJerseyHttpsClientFactory;
import de.iip_ecosphere.platform.support.aas.basyx.VabInvocablesCreator;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import de.iip_ecosphere.platform.support.net.SslUtils;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.slf4j.LoggerFactory;

public class VabHttpsInvocablesCreator
extends VabInvocablesCreator {
    private static final long serialVersionUID = 8021322086051502297L;
    private String address;
    private KeyStoreDescriptor kstore;
    private transient BaSyxJerseyHttpsClientFactory factory;

    VabHttpsInvocablesCreator(String address, KeyStoreDescriptor kstore) {
        this.address = address;
        this.kstore = kstore;
    }

    @Override
    protected VABElementProxy createProxy() {
        if (null == this.factory && null != this.kstore) {
            try {
                KeyStore ks = SslUtils.openKeyStore((File)this.kstore.getPath(), (String)this.kstore.getPassword());
                TrustManagerFactory tmf = SslUtils.createTrustManagerFactory((KeyStore)ks);
                KeyManager[] kms = SslUtils.createKeyManagers((KeyStore)ks, (String)this.kstore.getPassword(), (String)this.kstore.getAlias());
                this.factory = new BaSyxJerseyHttpsClientFactory(kms, tmf.getTrustManagers());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(VabHttpsInvocablesCreator.class).error("Creating VAB-HTTPS client factory: " + e.getMessage());
            }
        }
        return new VABElementProxy("", (IModelProvider)new JSONConnector((IBaSyxConnector)new BaSyxHTTPSConnector(this.address, this.factory)));
    }

    @Override
    protected String getId() {
        return this.address;
    }
}

