/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Type;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.basyx.aas.metamodel.map.descriptor.CustomId;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;

public class Tools {
    private static final Map<Type, ValueType> TYPES2BASYX = new HashMap<Type, ValueType>();
    private static final Map<ValueType, Type> BASYX2TYPES = new HashMap<ValueType, Type>();
    private static final Map<AssetKind, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind> ASSETKINDS2BASYX = new HashMap<AssetKind, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind>();
    private static final Map<org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind, AssetKind> BASYX2ASSETKINDS = new HashMap<org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind, AssetKind>();

    private static void mapType(Type type, ValueType basyxType) {
        TYPES2BASYX.put(type, basyxType);
        BASYX2TYPES.put(basyxType, type);
    }

    private static void mapKind(AssetKind kind, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind basyxKind) {
        ASSETKINDS2BASYX.put(kind, basyxKind);
        BASYX2ASSETKINDS.put(basyxKind, kind);
    }

    public static String checkUrn(String urn) {
        if (null == urn || 0 == urn.length()) {
            throw new IllegalArgumentException("urn must be given");
        }
        return urn;
    }

    public static String checkId(String idShort) {
        if (null == idShort || 0 == idShort.length()) {
            throw new IllegalArgumentException("idShort must be given");
        }
        if (!idShort.matches("[a-zA-Z][a-zA-Z0-9_]+")) {
            throw new IllegalArgumentException("idShort '" + idShort + "' shall only feature letters, digits, underscore (\"_\"); starting mandatory with a letter.");
        }
        if (idShort.equals("value") || idShort.equals("invocationList")) {
            throw new IllegalArgumentException("idShort shall not be \"" + idShort + "\"");
        }
        return idShort;
    }

    public static ValueType translate(Type type) {
        return TYPES2BASYX.get(type);
    }

    public static Type translate(ValueType type) {
        return BASYX2TYPES.get(type);
    }

    public static org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind translate(AssetKind kind) {
        return ASSETKINDS2BASYX.get(kind);
    }

    public static AssetKind translate(org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind kind) {
        return BASYX2ASSETKINDS.get(kind);
    }

    static String idToUrlPath(String id) {
        return id;
    }

    public static IIdentifier translateIdentifier(String id, String dfltCustom) {
        Object result = null == id || id.length() == 0 ? new CustomId(dfltCustom) : (id.startsWith("urn:") ? new ModelUrn(id) : (id.startsWith("urnText:") ? new ModelUrn(id.substring("urnText:".length())) : (id.startsWith("irdi:") ? new Identifier(IdentifierType.IRDI, id.substring("irdi:".length())) : (id.startsWith("iri:") ? new Identifier(IdentifierType.IRI, id.substring("iri:".length())) : new CustomId(id)))));
        return result;
    }

    public static String translateIdentifier(IIdentifier identifier) {
        Object result = null;
        if (identifier instanceof ModelUrn) {
            result = ((ModelUrn)identifier).getURN();
            if (!((String)result).startsWith("urn:")) {
                result = "urn:" + (String)result;
            }
        } else if (null != identifier) {
            switch (identifier.getIdType()) {
                case IRDI: {
                    result = "irdi:" + identifier.getId();
                    break;
                }
                case IRI: {
                    result = "iri:" + identifier.getId();
                    break;
                }
                default: {
                    result = identifier.getId();
                }
            }
        }
        return result;
    }

    public static IReference translateReference(String id) {
        Reference result = null;
        if (id != null) {
            if (id.startsWith("irdi:")) {
                result = new Reference(Collections.singletonList(new Key(KeyElements.CONCEPTDESCRIPTION, false, id.substring("irdi:".length()), KeyType.IRDI)));
            } else if (id.startsWith("iri:")) {
                result = new Reference(Collections.singletonList(new Key(KeyElements.CONCEPTDESCRIPTION, false, id.substring("iri:".length()), KeyType.IRI)));
            }
        }
        return result;
    }

    public static String translateReference(IReference ref, boolean stripPrefix) {
        String result = null;
        if (ref != null && ref.getKeys().size() > 0) {
            IKey key = (IKey)ref.getKeys().get(0);
            switch (key.getIdType()) {
                case IRDI: {
                    result = Tools.compose("irdi:", key.getValue(), stripPrefix);
                    break;
                }
                case IRI: {
                    result = Tools.compose("iri:", key.getValue(), stripPrefix);
                    break;
                }
            }
        }
        return result;
    }

    private static String compose(String prefix, String value, boolean stripPrefix) {
        Object result = stripPrefix ? value : prefix + value;
        return result;
    }

    public static <E extends Enum<E>> E getOption(String[] options, E dflt, Class<E> cls) {
        E result = dflt;
        for (String o : options) {
            try {
                result = Enum.valueOf(cls, o);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    static void disposeTomcatWorkingDir(File baseDir, int port) {
        File workDir;
        if (null == baseDir) {
            baseDir = new File(".");
        }
        if ((workDir = new File(baseDir, "tomcat." + port)).exists() && !FileUtils.deleteQuietly((File)workDir)) {
            try {
                FileUtils.forceDeleteOnExit((File)workDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString translate(LangString ls) {
        return new org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString(ls.getLanguage(), ls.getDescription());
    }

    public static LangString translate(org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString ls) {
        return new LangString(ls.getLanguage(), ls.getDescription());
    }

    public static Object translateValueToBaSyx(ValueType type, Object value) {
        if (type == ValueType.LangString) {
            if (value instanceof String) {
                value = LangString.create((String)((String)value));
            }
            if (value instanceof LangString) {
                value = Tools.translate((LangString)value);
            }
        }
        return value;
    }

    public static Object translateValueFromBaSyx(Object val, ValueType type) {
        if (ValueType.LangString == type) {
            if (org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString.isLangString((Object)val)) {
                val = Tools.translate(org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString.createAsFacade((Map)((Map)val)));
            } else if (val instanceof String) {
                Gson gson = new Gson();
                try {
                    Map map = (Map)gson.fromJson(val.toString(), Map.class);
                    val = Tools.translate(org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString.createAsFacade((Map)map));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
        }
        return val;
    }

    public static ValueType getType(ISubmodelElement elt) {
        ValueType result = null;
        if (elt instanceof Property) {
            result = ((Property)elt).getValueType();
        }
        return result;
    }

    static {
        Tools.mapType(Type.BOOLEAN, ValueType.Boolean);
        Tools.mapType(Type.DOUBLE, ValueType.Double);
        Tools.mapType(Type.FLOAT, ValueType.Float);
        Tools.mapType(Type.INTEGER, ValueType.Int32);
        Tools.mapType(Type.AAS_INTEGER, ValueType.Integer);
        Tools.mapType(Type.STRING, ValueType.String);
        Tools.mapType(Type.NON_POSITIVE_INTEGER, ValueType.NonPositiveInteger);
        Tools.mapType(Type.NON_NEGATIVE_INTEGER, ValueType.NonNegativeInteger);
        Tools.mapType(Type.POSITIVE_INTEGER, ValueType.PositiveInteger);
        Tools.mapType(Type.NEGATIVE_INTEGER, ValueType.NegativeInteger);
        Tools.mapType(Type.INT8, ValueType.Int8);
        Tools.mapType(Type.INT16, ValueType.Int16);
        Tools.mapType(Type.INT32, ValueType.Int32);
        Tools.mapType(Type.INT64, ValueType.Int64);
        Tools.mapType(Type.UINT8, ValueType.UInt8);
        Tools.mapType(Type.UINT16, ValueType.UInt16);
        Tools.mapType(Type.UINT32, ValueType.UInt32);
        Tools.mapType(Type.UINT64, ValueType.UInt64);
        Tools.mapType(Type.LANG_STRING, ValueType.LangString);
        Tools.mapType(Type.ANY_URI, ValueType.AnyURI);
        Tools.mapType(Type.BASE64_BINARY, ValueType.Base64Binary);
        Tools.mapType(Type.HEX_BINARY, ValueType.HexBinary);
        Tools.mapType(Type.NOTATION, ValueType.NOTATION);
        Tools.mapType(Type.ENTITY, ValueType.ENTITY);
        Tools.mapType(Type.ID, ValueType.ID);
        Tools.mapType(Type.IDREF, ValueType.IDREF);
        Tools.mapType(Type.DURATION, ValueType.Duration);
        Tools.mapType(Type.DAY_TIME_DURATION, ValueType.DayTimeDuration);
        Tools.mapType(Type.YEAR_MONTH_DURATION, ValueType.YearMonthDuration);
        Tools.mapType(Type.DATE_TIME, ValueType.DateTime);
        Tools.mapType(Type.DATE_TIME_STAMP, ValueType.DateTimeStamp);
        Tools.mapType(Type.G_DAY, ValueType.GDay);
        Tools.mapType(Type.G_MONTH, ValueType.GMonth);
        Tools.mapType(Type.G_MONTH_DAY, ValueType.GMonthDay);
        Tools.mapType(Type.G_YEAR, ValueType.GYear);
        Tools.mapType(Type.G_YEAR_MONTH, ValueType.GYearMonth);
        Tools.mapType(Type.Q_NAME, ValueType.QName);
        Tools.mapType(Type.NONE, ValueType.None);
        Tools.mapType(Type.ANY_TYPE, ValueType.AnyType);
        Tools.mapType(Type.ANY_SIMPLE_TYPE, ValueType.AnySimpleType);
        Tools.mapKind(AssetKind.TYPE, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind.TYPE);
        Tools.mapKind(AssetKind.INSTANCE, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind.INSTANCE);
    }
}

