/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAasDescriptor;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;

class DeploymentSpec {
    private Endpoint endpoint;
    private BaSyxContextConfiguration contextConfig;
    private BaSyxContext context;
    private IAASRegistry registry;
    private Map<String, BaSyxAasDescriptor> descriptors = new HashMap<String, BaSyxAasDescriptor>();

    DeploymentSpec() {
    }

    DeploymentSpec(Endpoint endpoint) {
        this(endpoint, "", null);
    }

    DeploymentSpec(Endpoint endpoint, KeyStoreDescriptor kstore) {
        this(endpoint, "", kstore);
    }

    DeploymentSpec(Endpoint endpoint, String docPath) {
        this(endpoint, docPath, null);
    }

    DeploymentSpec(Endpoint endpoint, String docPath, KeyStoreDescriptor kstore) {
        this.endpoint = endpoint;
        this.context = null != kstore && null != kstore.getPath() ? new BaSyxContext(endpoint.getEndpoint(), docPath, endpoint.getHost(), endpoint.getPort(), true, kstore.getAbsolutePath(), kstore.getPassword()) : new BaSyxContext(endpoint.getEndpoint(), docPath, endpoint.getHost(), endpoint.getPort());
        this.contextConfig = new BaSyxContextConfiguration(endpoint.getEndpoint(), "", endpoint.getHost(), endpoint.getPort()){

            public BaSyxContext createBaSyxContext() {
                return DeploymentSpec.this.context;
            }
        };
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.context.setAccessControlAllowOrigin(accessControlAllowOrigin);
    }

    public void setJwtBearerTokenAuthenticationConfiguration(@Nullable JwtBearerTokenAuthenticationConfiguration conf) {
        this.context.setJwtBearerTokenAuthenticationConfiguration(conf);
    }

    BaSyxContext getContext() {
        return this.context;
    }

    Endpoint getEndpoint() {
        return this.endpoint;
    }

    BaSyxContextConfiguration getContextConfiguration() {
        return this.contextConfig;
    }

    void putDescriptor(String idShort, BaSyxAasDescriptor descriptor) {
        this.descriptors.put(idShort, descriptor);
    }

    BaSyxAasDescriptor getDescriptor(String idShort) {
        return this.descriptors.get(idShort);
    }

    IAASRegistry getRegistry() {
        return this.registry;
    }

    void setRegistry(IAASRegistry registry) {
        this.registry = registry;
    }
}

