/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxElementTranslator;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxFile;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;

public class BaSyxSubmodelElementCollection
extends BaSyxSubmodelElement
implements SubmodelElementCollection,
BaSyxElementTranslator.SubmodelElementsRegistrar {
    private ISubmodelElementCollection collection;
    private Map<String, SubmodelElement> elements;
    private Map<String, Builder<?>> deferred;

    protected BaSyxSubmodelElementCollection() {
    }

    protected BaSyxSubmodelElementCollection(ISubmodelElementCollection collection) {
        this.collection = collection;
    }

    private void initialize() {
        if (null == this.elements) {
            this.elements = new HashMap<String, SubmodelElement>();
            BaSyxElementTranslator.registerSubmodelElements(this.collection.getSubmodelElements(), this);
        }
    }

    public int getElementsCount() {
        this.initialize();
        return this.elements.size();
    }

    public Iterable<SubmodelElement> elements() {
        this.initialize();
        return this.elements.values();
    }

    protected Iterable<SubmodelElement> getElements(final Predicate<SubmodelElement> filter) {
        return new Iterable<SubmodelElement>(){

            @Override
            public Iterator<SubmodelElement> iterator() {
                return BaSyxSubmodelElementCollection.this.elements.values().stream().filter(filter).iterator();
            }
        };
    }

    protected <E extends SubmodelElement> Iterable<E> getElements(final Predicate<SubmodelElement> filter, final Class<E> castType) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return BaSyxSubmodelElementCollection.this.elements.values().stream().filter(e -> castType.isInstance(e)).filter(filter).map(e -> (SubmodelElement)castType.cast(e)).iterator();
            }
        };
    }

    protected Iterable<SubmodelElementCollection> getSubmodelElementCollections(final Predicate<SubmodelElementCollection> filter) {
        return new Iterable<SubmodelElementCollection>(){

            @Override
            public Iterator<SubmodelElementCollection> iterator() {
                return BaSyxSubmodelElementCollection.this.elements.values().stream().filter(e -> e instanceof SubmodelElementCollection).map(SubmodelElementCollection.class::cast).filter(filter).iterator();
            }
        };
    }

    public String getIdShort() {
        return this.collection.getIdShort();
    }

    public ISubmodelElementCollection getSubmodelElement() {
        return this.collection;
    }

    public DataElement getDataElement(String idShort) {
        return this.getElement(idShort, DataElement.class);
    }

    public Property getProperty(String idShort) {
        return this.getElement(idShort, Property.class);
    }

    public Operation getOperation(String idShort) {
        return this.getElement(idShort, Operation.class);
    }

    public ReferenceElement getReferenceElement(String idShort) {
        return this.getElement(idShort, ReferenceElement.class);
    }

    public SubmodelElement getElement(String idShort) {
        this.initialize();
        return this.elements.get(idShort);
    }

    private <T extends SubmodelElement> T getElement(String idShort, Class<T> type) {
        SubmodelElement result = null;
        SubmodelElement tmp = this.getElement(idShort);
        if (type.isInstance(tmp)) {
            result = (SubmodelElement)type.cast(tmp);
        }
        return (T)result;
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        return this.getElement(idShort, SubmodelElementCollection.class);
    }

    @Override
    public BaSyxProperty register(BaSyxProperty property) {
        this.elements.put(property.getIdShort(), property);
        return property;
    }

    @Override
    public BaSyxFile register(BaSyxFile file) {
        this.elements.put(file.getIdShort(), file);
        return file;
    }

    @Override
    public BaSyxOperation register(BaSyxOperation operation) {
        this.elements.put(operation.getIdShort(), operation);
        return operation;
    }

    @Override
    public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
        this.elements.put(reference.getIdShort(), reference);
        return reference;
    }

    @Override
    public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
        this.elements.put(collection.getIdShort(), collection);
        return collection;
    }

    @Override
    public <D extends org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement> BaSyxDataElement<D> register(BaSyxDataElement<D> dataElement) {
        this.elements.put(dataElement.getIdShort(), dataElement);
        return dataElement;
    }

    public void accept(AasVisitor visitor) {
        this.initialize();
        visitor.visitSubmodelElementCollection((SubmodelElementCollection)this);
        for (SubmodelElement se : this.elements.values()) {
            se.accept(visitor);
        }
        visitor.endSubmodelElementCollection((SubmodelElementCollection)this);
    }

    public Reference createReference() {
        return new BaSyxReference(this.collection.getReference());
    }

    public void deleteElement(String idShort) {
        this.initialize();
        if (this.elements.containsKey(idShort)) {
            this.elements.remove(idShort);
            this.collection.deleteSubmodelElement(idShort);
        }
    }

    @Override
    public void update() {
        this.elements = null;
    }

    public static class BaSyxSubmodelElementCollectionBuilder
    extends BaSyxSubmodelElementContainerBuilder<ISubmodel>
    implements SubmodelElementCollection.SubmodelElementCollectionBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxSubmodelElementCollection instance;
        private ISubmodelElementCollection collection;
        private boolean isNew = true;

        protected BaSyxSubmodelElementCollectionBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort, boolean ordered, boolean allowDuplicates) {
            this(parentBuilder, idShort, () -> new BaSyxSubmodelElementCollection(), () -> {
                org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection coll = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection();
                coll.setIdShort(Tools.checkId(idShort));
                coll.setOrdered(ordered);
                coll.setAllowDuplicates(allowDuplicates);
                return coll;
            });
        }

        protected BaSyxSubmodelElementCollectionBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort, Supplier<BaSyxSubmodelElementCollection> wCreator, Supplier<org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection> bCreator) {
            this.parentBuilder = parentBuilder;
            this.instance = wCreator.get();
            this.instance.elements = new HashMap<String, SubmodelElement>();
            this.collection = (ISubmodelElementCollection)bCreator.get();
        }

        protected BaSyxSubmodelElementCollectionBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, BaSyxSubmodelElementCollection instance) {
            this.parentBuilder = parentBuilder;
            this.instance = instance;
            this.isNew = false;
            if (!(instance.collection instanceof ISubmodelElementCollection)) {
                throw new IllegalArgumentException("Cannot create a " + this.getClass().getSimpleName() + " on a " + instance.collection.getClass().getSimpleName());
            }
            this.collection = instance.collection;
            this.instance.initialize();
        }

        protected ISubmodelElementCollection getCollection() {
            return this.collection;
        }

        protected BaSyxSubmodelElementCollection getCollectionInstance() {
            return this.instance;
        }

        @Override
        public Property.PropertyBuilder createPropertyBuilder(String idShort) {
            return new BaSyxProperty.BaSyxPropertyBuilder(this, idShort);
        }

        @Override
        public ReferenceElement.ReferenceElementBuilder createReferenceElementBuilder(String idShort) {
            return new BaSyxReferenceElement.BaSyxReferenceElementBuilder(this, idShort);
        }

        @Override
        public Operation.OperationBuilder createOperationBuilder(String idShort) {
            return new BaSyxOperation.BaSxyOperationBuilder(this, idShort);
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort, boolean ordered, boolean allowDuplicates) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder result = (SubmodelElementCollection.SubmodelElementCollectionBuilder)DeferredBuilder.getDeferred((String)idShort, SubmodelElementCollection.SubmodelElementCollectionBuilder.class, this.instance.deferred);
            if (null == result) {
                SubmodelElementCollection sub = this.instance.getSubmodelElementCollection(idShort);
                result = null == sub ? new BaSyxSubmodelElementCollectionBuilder(this, idShort, ordered, allowDuplicates) : new BaSyxSubmodelElementCollectionBuilder(this, (BaSyxSubmodelElementCollection)sub);
            }
            return result;
        }

        @Override
        public Reference createReference() {
            return new BaSyxReference(this.collection.getReference());
        }

        @Override
        protected BaSyxFile register(BaSyxFile file) {
            this.collection.addSubmodelElement(file.getSubmodelElement());
            return this.instance.register(file);
        }

        @Override
        protected BaSyxOperation register(BaSyxOperation operation) {
            this.collection.addSubmodelElement((ISubmodelElement)operation.getSubmodelElement());
            return this.instance.register(operation);
        }

        @Override
        protected BaSyxProperty register(BaSyxProperty property) {
            this.collection.addSubmodelElement(property.getSubmodelElement());
            BaSyxProperty p = this.instance.register(property);
            return p;
        }

        @Override
        protected BaSyxReferenceElement register(BaSyxReferenceElement reference) {
            this.collection.addSubmodelElement((ISubmodelElement)reference.getSubmodelElement());
            return this.instance.register(reference);
        }

        @Override
        protected BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
            this.collection.addSubmodelElement((ISubmodelElement)collection.getSubmodelElement());
            return this.instance.register(collection);
        }

        public void defer() {
            this.parentBuilder.defer(this.collection.getIdShort(), (Builder<?>)this);
        }

        @Override
        void defer(String shortId, Builder<?> builder) {
            this.instance.deferred = DeferredBuilder.defer((String)shortId, builder, this.instance.deferred);
        }

        @Override
        void buildMyDeferred() {
            DeferredBuilder.buildDeferred(this.instance.deferred);
        }

        public void buildDeferred() {
            this.parentBuilder.buildMyDeferred();
        }

        public BaSyxSubmodelElementCollection build() {
            this.buildMyDeferred();
            this.instance.collection = this.collection;
            if (this.isNew) {
                this.parentBuilder.register(this.instance);
            }
            return this.instance;
        }

        public Aas.AasBuilder getAasBuilder() {
            return this.parentBuilder.getAasBuilder();
        }

        public SubmodelElementContainerBuilder getParentBuilder() {
            return this.parentBuilder;
        }

        @Override
        protected AbstractSubmodel<ISubmodel> getInstance() {
            return null;
        }

        public boolean isNew() {
            return this.isNew;
        }
    }
}

