/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistryDeploymentAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.registry.RegistryComponent;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;
import org.slf4j.LoggerFactory;

public class BaSyxServerRecipe
implements ServerRecipe {
    public ServerRecipe.PersistenceType toPersistenceType(String type) {
        ServerRecipe.LocalPersistenceType result = ServerRecipe.LocalPersistenceType.INMEMORY;
        try {
            result = ServerRecipe.LocalPersistenceType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Persistence type '" + type + "' is unknown. Using " + ServerRecipe.LocalPersistenceType.INMEMORY + " as fallback.");
        }
        return result;
    }

    public AasServer createAasServer(Endpoint serverEndpoint, ServerRecipe.PersistenceType persistence, Endpoint registryEndpoint, String ... options) {
        return this.createAasServer(serverEndpoint, persistence, registryEndpoint, (KeyStoreDescriptor)null, options);
    }

    public AasServer createAasServer(Endpoint serverEndpoint, ServerRecipe.PersistenceType persistence, Endpoint registryEndpoint, KeyStoreDescriptor kstore, String ... options) {
        return new BaSyxRegistryDeploymentAasServer(new DeploymentSpec(serverEndpoint, kstore), registryEndpoint.toUri(), this.translateForServer(persistence), options);
    }

    public Server createRegistryServer(Endpoint endpoint, ServerRecipe.PersistenceType persistence, String ... options) {
        return this.createRegistryServer(endpoint, persistence, (KeyStoreDescriptor)null, options);
    }

    public Server createRegistryServer(Endpoint endpoint, ServerRecipe.PersistenceType persistence, KeyStoreDescriptor kstore, String ... options) {
        DeploymentSpec spec = new DeploymentSpec(endpoint, (KeyStoreDescriptor)null);
        RegistryBackend backend = Tools.getOption(options, this.translateForRegistry(persistence), RegistryBackend.class);
        BaSyxRegistryConfiguration registryConfig = new BaSyxRegistryConfiguration(backend);
        RegistryComponent component = new RegistryComponent(spec.getContextConfiguration(), registryConfig);
        return new Server((IComponent)component, endpoint){
            final /* synthetic */ IComponent val$component;
            final /* synthetic */ Endpoint val$endpoint;
            {
                this.val$component = iComponent;
                this.val$endpoint = endpoint;
            }

            public Server start() {
                this.val$component.startComponent();
                return this;
            }

            public void stop(boolean dispose) {
                this.val$component.stopComponent();
                if (dispose) {
                    Tools.disposeTomcatWorkingDir(null, this.val$endpoint.getPort());
                }
            }
        };
    }

    protected RegistryBackend translateForRegistry(ServerRecipe.PersistenceType type) {
        if (ServerRecipe.LocalPersistenceType.INMEMORY != type) {
            throw new UnsupportedOperationException("Persistence type '" + type + "' is not supported as registry backend");
        }
        RegistryBackend result = RegistryBackend.INMEMORY;
        return result;
    }

    protected AASServerBackend translateForServer(ServerRecipe.PersistenceType type) {
        if (ServerRecipe.LocalPersistenceType.INMEMORY != type) {
            throw new UnsupportedOperationException("Persistence type '" + type + "' is not supported as server backend");
        }
        AASServerBackend result = AASServerBackend.INMEMORY;
        return result;
    }
}

