/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.haskind.ModelingKind;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.slf4j.LoggerFactory;

public class BaSyxOperation
extends BaSyxSubmodelElement
implements Operation {
    private IOperation operation;

    private BaSyxOperation() {
    }

    BaSyxOperation(IOperation operation) {
        this.operation = operation;
    }

    IOperation getOperation() {
        return this.operation;
    }

    public String getIdShort() {
        return this.operation.getIdShort();
    }

    public int getInArgsCount() {
        return this.operation.getInputVariables().size();
    }

    public int getOutArgsCount() {
        return this.operation.getOutputVariables().size();
    }

    public int getInOutArgsCount() {
        return this.operation.getInOutputVariables().size();
    }

    public int getArgsCount() {
        return this.getInArgsCount() + this.getOutArgsCount() + this.getInOutArgsCount();
    }

    public Object invoke(Object ... args) throws ExecutionException {
        try {
            ISubmodelElement outVar;
            ValueType type = null;
            if (this.operation.getOutputVariables().size() > 0 && (outVar = ((IOperationVariable)this.operation.getOutputVariables().iterator().next()).getValue()) instanceof Property) {
                type = ((Property)outVar).getValueType();
            }
            return Tools.translateValueFromBaSyx(this.operation.invokeSimple(args), type);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    IOperation getSubmodelElement() {
        return this.operation;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitOperation((Operation)this);
    }

    public static class BaSxyOperationBuilder
    implements Operation.OperationBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxOperation instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation operation;
        private List<OperationVariable> inputVariables;
        private List<OperationVariable> outputVariables;
        private List<OperationVariable> inOutVariables;

        BaSxyOperationBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxOperation();
            this.operation = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation();
            this.operation.setIdShort(Tools.checkId(idShort));
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        private OperationVariable createOperationVariable(String idShort, Type type) {
            Property prop = new Property();
            prop.setIdShort(idShort);
            prop.setKind(ModelingKind.TEMPLATE);
            if (null != type) {
                prop.setValueType(Tools.translate(type));
            }
            return new OperationVariable((SubmodelElement)prop);
        }

        public Operation.OperationBuilder addInputVariable(String idShort, Type type) {
            if (null == this.inputVariables) {
                this.inputVariables = new ArrayList<OperationVariable>();
            }
            this.inputVariables.add(this.createOperationVariable(idShort, type));
            return this;
        }

        public Operation.OperationBuilder addOutputVariable(String idShort, Type type) {
            if (null == this.outputVariables) {
                this.outputVariables = new ArrayList<OperationVariable>();
            }
            this.outputVariables.add(this.createOperationVariable(idShort, type));
            return this;
        }

        public Operation.OperationBuilder addInOutVariable(String idShort, Type type) {
            if (null == this.outputVariables) {
                this.outputVariables = new ArrayList<OperationVariable>();
            }
            this.inOutVariables.add(this.createOperationVariable(idShort, type));
            return this;
        }

        public Operation.OperationBuilder setInvocable(Function<Object[], Object> invocable) {
            if (invocable != null && !(invocable instanceof Serializable)) {
                throw new IllegalArgumentException("'invocable' for operation '" + this.operation.getIdShort() + "' must be Serializable.");
            }
            return this.setInvocableLazy(invocable);
        }

        public Operation.OperationBuilder setInvocableLazy(Function<Object[], Object> invocable) {
            this.operation.setInvokable(invocable);
            return this;
        }

        public Operation build() {
            if (null != this.inputVariables) {
                this.operation.setInputVariables(this.inputVariables);
            }
            if (null == this.outputVariables) {
                this.addOutputVariable("result", Type.NONE);
                LoggerFactory.getLogger(BaSyxOperation.class).warn("No result output variable specified for operation '{}'. Creating an implicit variable of type NONE.", (Object)this.operation.getIdShort());
            }
            if (null != this.outputVariables) {
                this.operation.setOutputVariables(this.outputVariables);
            }
            if (null != this.inOutVariables) {
                this.operation.setInOutputVariables(this.inOutVariables);
            }
            this.instance.operation = this.operation;
            return this.parentBuilder.register(this.instance);
        }
    }
}

