/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAasDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxImmediateDeploymentAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistry;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistryDeploymentAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.aas.registration.restapi.AASRegistryModelProvider;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.submodel.restapi.SubmodelProvider;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;
import org.slf4j.LoggerFactory;

public class BaSyxDeploymentRecipe
implements DeploymentRecipe {
    private DeploymentSpec deploymentSpec;

    BaSyxDeploymentRecipe(Endpoint endpoint) {
        this.deploymentSpec = new DeploymentSpec(endpoint);
    }

    BaSyxDeploymentRecipe(Endpoint endpoint, KeyStoreDescriptor kstore) {
        this.deploymentSpec = new DeploymentSpec(endpoint, kstore);
    }

    BaSyxDeploymentRecipe(String host, int port, String contextPath, String docBasePath) {
        this.deploymentSpec = new DeploymentSpec(new Endpoint(Schema.IGNORE, host, port, contextPath), docBasePath);
    }

    public DeploymentRecipe setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.deploymentSpec.setAccessControlAllowOrigin(accessControlAllowOrigin);
        return this;
    }

    public DeploymentRecipe setBearerTokenAuthenticationConfiguration(String issuerUri, String jwkSetUri, String requiredAud) throws IllegalArgumentException {
        this.deploymentSpec.setJwtBearerTokenAuthenticationConfiguration(JwtBearerTokenAuthenticationConfiguration.of((String)issuerUri, (String)jwkSetUri, (String)requiredAud));
        return this;
    }

    public DeploymentRecipe.ImmediateDeploymentRecipe addInMemoryRegistry(Endpoint regEndpoint) {
        if (regEndpoint.getSchema() != this.deploymentSpec.getEndpoint().getSchema()) {
            LoggerFactory.getLogger(this.getClass()).warn("");
        }
        return this.addInMemoryRegistry(regEndpoint.getEndpoint());
    }

    public DeploymentRecipe.ImmediateDeploymentRecipe addInMemoryRegistry(String regEndpoint) {
        this.deploymentSpec.setRegistry((IAASRegistry)new InMemoryRegistry());
        AASRegistryModelProvider registryProvider = new AASRegistryModelProvider(this.deploymentSpec.getRegistry());
        VABHTTPInterface registryServlet = new VABHTTPInterface((IModelProvider)registryProvider);
        this.deploymentSpec.getContext().addServletMapping(Endpoint.checkEndpoint((String)regEndpoint) + "/*", (HttpServlet)registryServlet);
        return new BaSyxImmediateDeploymentRecipe();
    }

    public DeploymentRecipe.RegistryDeploymentRecipe setRegistryUrl(Endpoint endpoint) {
        return new BaSyxRegistryDeploymentRecipe(endpoint);
    }

    static void deploy(DeploymentSpec deploymentSpec, Aas aas) {
        if (null == deploymentSpec.getRegistry()) {
            throw new IllegalArgumentException("No registry created before");
        }
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be of instance BaSyxAas, i.e., created through the AasFactory.");
        }
        BaSyxAas bAas = (BaSyxAas)aas;
        AASModelProvider aasProvider = new AASModelProvider((AssetAdministrationShell)bAas.getAas());
        MultiSubmodelProvider fullProvider = new MultiSubmodelProvider();
        fullProvider.setAssetAdministrationShell(aasProvider);
        AASDescriptor aasDescriptor = new AASDescriptor(bAas.getAas(), AbstractAas.getAasEndpoint((ServerAddress)deploymentSpec.getEndpoint(), aas));
        for (Submodel sm : bAas.submodels()) {
            if (!(sm instanceof BaSyxSubmodel)) continue;
            BaSyxSubmodel submodel = (BaSyxSubmodel)sm;
            SubmodelProvider subModelProvider = new SubmodelProvider((org.eclipse.basyx.submodel.metamodel.map.Submodel)submodel.getSubmodel());
            fullProvider.addSubmodel(subModelProvider);
            aasDescriptor.addSubmodelDescriptor(new SubmodelDescriptor(submodel.getSubmodel(), AbstractSubmodel.getSubmodelEndpoint((ServerAddress)deploymentSpec.getEndpoint(), aas, submodel)));
        }
        VABHTTPInterface aasServlet = new VABHTTPInterface((IModelProvider)fullProvider);
        deploymentSpec.getRegistry().register(aasDescriptor);
        String ep = deploymentSpec.getEndpoint().getEndpoint();
        while (ep.length() > 0 && ep.endsWith("/")) {
            ep = ep.substring(0, ep.length() - 1);
        }
        deploymentSpec.getContext().addServletMapping(ep + "/" + Tools.idToUrlPath(aas.getIdShort()) + "/*", (HttpServlet)aasServlet);
        deploymentSpec.putDescriptor(aas.getIdShort(), new BaSyxAasDescriptor(fullProvider, aasDescriptor));
    }

    private class BaSyxRegistryDeploymentRecipe
    implements DeploymentRecipe.RegistryDeploymentRecipe {
        private Endpoint endpoint;

        private BaSyxRegistryDeploymentRecipe(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public Registry obtainRegistry() throws IOException {
            return AasFactory.getInstance().obtainRegistry(this.endpoint, BaSyxDeploymentRecipe.this.deploymentSpec.getEndpoint().getSchema());
        }

        public DeploymentRecipe.RegistryDeploymentRecipe deploy(Aas aas) {
            try {
                BaSyxDeploymentRecipe.this.deploymentSpec.setRegistry(((BaSyxRegistry)this.obtainRegistry()).getRegistry());
                BaSyxDeploymentRecipe.deploy(BaSyxDeploymentRecipe.this.deploymentSpec, aas);
                return this;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public AasServer createServer(String ... options) {
            return new BaSyxRegistryDeploymentAasServer(BaSyxDeploymentRecipe.this.deploymentSpec, this.endpoint.toUri(), AASServerBackend.INMEMORY, options);
        }
    }

    private class BaSyxImmediateDeploymentRecipe
    implements DeploymentRecipe.ImmediateDeploymentRecipe {
        private BaSyxImmediateDeploymentRecipe() {
        }

        public DeploymentRecipe.ImmediateDeploymentRecipe deploy(Aas aas) {
            BaSyxDeploymentRecipe.deploy(BaSyxDeploymentRecipe.this.deploymentSpec, aas);
            return this;
        }

        public AasServer createServer(String ... options) {
            return new BaSyxImmediateDeploymentAasServer(BaSyxDeploymentRecipe.this.deploymentSpec);
        }
    }
}

