/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasFactoryDescriptor;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SimpleLocalProtocolCreator;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistry;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxServerRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.VabHttpInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.basyx.VabHttpsInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.basyx.VabOperationsProvider;
import de.iip_ecosphere.platform.support.aas.basyx.VabTcpInvocablesCreator;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.IOException;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.SubmodelElementIdShortBlacklist;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.eclipse.basyx.vab.protocol.https.HTTPSConnectorProvider;

public class BaSyxAasFactory
extends AasFactory {
    public static final String PROTOCOL_VAB_TCP = "VAB-TCP";
    public static final String PROTOCOL_VAB_HTTP = "VAB-HTTP";
    public static final String PROTOCOL_VAB_HTTPS = "VAB-HTTPS";

    public BaSyxAasFactory() {
        this.registerProtocolCreator("local", (AasFactory.ProtocolCreator)new SimpleLocalProtocolCreator(){

            protected OperationsProvider createOperationsProvider() {
                return new VabOperationsProvider();
            }
        });
        VabTcpProtocolCreator tcp = new VabTcpProtocolCreator();
        this.registerProtocolCreator("", tcp);
        this.registerProtocolCreator(PROTOCOL_VAB_TCP, tcp);
        this.registerProtocolCreator(PROTOCOL_VAB_HTTP, new VabHttpProtocolCreator());
        this.registerProtocolCreator(PROTOCOL_VAB_HTTPS, new VabHttpsProtocolCreator());
    }

    public Aas.AasBuilder createAasBuilder(String idShort, String identifier) {
        return new BaSyxAas.BaSyxAasBuilder(idShort, identifier);
    }

    public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String identifier) {
        return new BaSyxSubmodel.BaSyxSubmodelBuilder(null, idShort, identifier);
    }

    protected ServerRecipe createDefaultServerRecipe() {
        return new BaSyxServerRecipe();
    }

    public Registry obtainRegistry(Endpoint endpoint) throws IOException {
        return this.obtainRegistry(endpoint, endpoint.getSchema());
    }

    public Registry obtainRegistry(Endpoint endpoint, Schema aasSchema) throws IOException {
        Object cFactory = Schema.HTTPS == aasSchema ? new HTTPSConnectorProvider() : new HTTPConnectorFactory();
        return new BaSyxRegistry(endpoint, (IConnectorFactory)cFactory);
    }

    public String getFullRegistryUri(Endpoint regEndpoint) {
        return regEndpoint.toUri() + "/api/v1/registry";
    }

    public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint) {
        return new BaSyxDeploymentRecipe(endpoint);
    }

    public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint, KeyStoreDescriptor kstore) {
        return new BaSyxDeploymentRecipe(endpoint, kstore);
    }

    public String getName() {
        return "AAS/BaSyx v1.3.0 (2022/12/15)";
    }

    public PersistenceRecipe createPersistenceRecipe() {
        return new BaSyxPersistenceRecipe();
    }

    protected boolean needsIdFix(String id) {
        return SubmodelElementIdShortBlacklist.isBlacklisted((String)id);
    }

    private static class VabHttpsProtocolCreator
    implements AasFactory.ProtocolCreator {
        private VabHttpsProtocolCreator() {
        }

        public InvocablesCreator createInvocablesCreator(String host, int port, KeyStoreDescriptor kstore) {
            return new VabHttpsInvocablesCreator("https://" + host + ":" + port, kstore);
        }

        public ProtocolServerBuilder createProtocolServerBuilder(int port, KeyStoreDescriptor kstore) {
            return new VabOperationsProvider.VabHttpOperationsBuilder(port, Schema.HTTPS, kstore);
        }
    }

    private static class VabHttpProtocolCreator
    implements AasFactory.ProtocolCreator {
        private VabHttpProtocolCreator() {
        }

        public InvocablesCreator createInvocablesCreator(String host, int port, KeyStoreDescriptor kstore) {
            return new VabHttpInvocablesCreator("http://" + host + ":" + port);
        }

        public ProtocolServerBuilder createProtocolServerBuilder(int port, KeyStoreDescriptor kstore) {
            return new VabOperationsProvider.VabHttpOperationsBuilder(port, Schema.HTTP, null);
        }
    }

    private static class VabTcpProtocolCreator
    implements AasFactory.ProtocolCreator {
        private VabTcpProtocolCreator() {
        }

        public InvocablesCreator createInvocablesCreator(String host, int port, KeyStoreDescriptor kstore) {
            return new VabTcpInvocablesCreator(host, port);
        }

        public ProtocolServerBuilder createProtocolServerBuilder(int port, KeyStoreDescriptor kstore) {
            return new VabOperationsProvider.VabTcpOperationsBuilder(port);
        }
    }

    public static class Descriptor
    implements AasFactoryDescriptor {
        public AasFactory createInstance() {
            return new BaSyxAasFactory();
        }
    }
}

