/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Asset;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAsset;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalDataSubmodel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.slf4j.LoggerFactory;

public abstract class AbstractAas<A extends IAssetAdministrationShell>
implements Aas {
    private A aas;
    private Map<String, Submodel> submodels = new HashMap<String, Submodel>();
    private BaSyxAsset asset;
    private Map<String, Builder<?>> deferred;

    protected AbstractAas(A aas) {
        this.aas = aas;
        IAsset asset = aas.getAsset();
        if (null != asset) {
            this.asset = new BaSyxAsset(asset);
        }
    }

    A getAas() {
        return this.aas;
    }

    public String getIdShort() {
        return this.aas.getIdShort();
    }

    public Iterable<Submodel> submodels() {
        return this.submodels.values();
    }

    public int getSubmodelCount() {
        return this.submodels.size();
    }

    public Submodel getSubmodel(String idShort) {
        try {
            return this.submodels.get(idShort);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    <S extends Submodel> S register(S submodel) {
        this.submodels.put(submodel.getIdShort(), submodel);
        return submodel;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitAas((Aas)this);
        if (null != this.asset) {
            this.asset.accept(visitor);
        }
        for (Submodel sm : this.submodels.values()) {
            sm.accept(visitor);
        }
        visitor.endAas((Aas)this);
    }

    public Reference createReference() {
        return new BaSyxReference(this.getAas().getReference());
    }

    public Asset getAsset() {
        return this.asset;
    }

    protected void setAsset(BaSyxAsset asset) {
        this.asset = asset;
    }

    public void delete(Submodel submodel) {
        if (null != submodel) {
            try {
                this.submodels.remove(submodel.getIdShort());
                this.getAas().removeSubmodel(((AbstractSubmodel)submodel).getSubmodel().getIdentification());
            }
            catch (ResourceNotFoundException e) {
                LoggerFactory.getLogger(this.getClass()).error("Deleting submodel {}: {}", (Object)submodel.getIdShort(), (Object)e.getMessage());
            }
        }
    }

    public static String getAasEndpoint(ServerAddress server, Aas aas) {
        return server.toServerUri() + "/" + Tools.idToUrlPath(aas.getIdShort()) + "/aas";
    }

    void defer(String shortId, Builder<?> builder) {
        this.deferred = DeferredBuilder.defer((String)shortId, builder, this.deferred);
    }

    public void buildDeferred() {
        DeferredBuilder.buildDeferred(this.deferred);
    }

    <B extends Builder<?>> B getDeferred(String shortId, Class<B> cls) {
        return (B)DeferredBuilder.getDeferred((String)shortId, cls, this.deferred);
    }

    public TechnicalDataSubmodel getTechnicalDataSubmodel() {
        return (TechnicalDataSubmodel)this.getSubmodel("TechnicalData");
    }

    public String getIdentification() {
        return Tools.translateIdentifier(this.aas.getIdentification());
    }

    public static abstract class BaSyxAbstractAasBuilder
    implements Aas.AasBuilder {
        abstract Submodel register(BaSyxSubmodel var1);

        abstract BaSyxSubmodelParent getSubmodelParent();

        abstract Aas getInstance();

        abstract void setAsset(BaSyxAsset var1);

        public Reference createReference() {
            return this.getInstance().createReference();
        }

        abstract void defer(String var1, Builder<?> var2);

        abstract void buildMyDeferred();
    }

    public static interface BaSyxSubmodelParent {
        public BaSyxAbstractAasBuilder createAasBuilder();
    }
}

