/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.TestUtils;
import test.de.iip_ecosphere.platform.support.aas.AasTest;

public class BaSyxTest
extends AasTest {
    protected KeyStoreDescriptor getKeyStoreDescriptor(String protocol) {
        KeyStoreDescriptor result = null;
        if ("VAB-HTTPS".equals(protocol)) {
            File f = new File("./src/test/resources/keystore.jks");
            System.out.println("Using Keystore: " + f.getAbsolutePath() + " " + f.exists());
            result = new KeyStoreDescriptor(f, "a1234567", "tomcat");
        }
        return result;
    }

    protected boolean excludeProtocol(String protocol) {
        boolean exclude = false;
        if ("VAB-HTTPS".equals(protocol)) {
            exclude = TestUtils.isSseCI();
            System.out.println("Checking exclusion: " + NetUtils.getOwnHostname() + " " + exclude);
        }
        return exclude;
    }

    public String[] getServerProtocols() {
        return new String[]{"", "VAB-HTTPS"};
    }

    @Test
    public void testLazy() {
        Aas.AasBuilder aas = AasFactory.getInstance().createAasBuilder("aasTest", null);
        Submodel.SubmodelBuilder sm = aas.createSubmodelBuilder("machine", null);
        try {
            sm.createPropertyBuilder("prop").setType(Type.INT32).bind(() -> null, null).build();
            Assert.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        sm.createPropertyBuilder("prop").setType(Type.INT32).bindLazy(() -> null, null).build();
        try {
            sm.createPropertyBuilder("prop").setType(Type.BOOLEAN).bind(null, v -> {}).build();
            Assert.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        sm.createPropertyBuilder("prop").setType(Type.BOOLEAN).bindLazy(null, v -> {}).build();
        try {
            sm.createPropertyBuilder("prop").bind(null, null).build();
            Assert.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sm.createOperationBuilder("op").setInvocable(p -> null).build();
            Assert.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        sm.createOperationBuilder("op").setInvocableLazy(p -> null).build();
        sm.build();
        aas.build();
    }
}

