/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class BaSyxCodecTest {
    @Test
    public void testCodecs() {
        AasFactory factory = AasFactory.getInstance();
        for (String protocol : factory.getProtocols()) {
            ProtocolServerBuilder builder;
            ProtocolServerBuilder.PayloadCodec codec;
            if ("local".equals(protocol) || null == (codec = (builder = factory.createProtocolServerBuilder(protocol, 8080)).createPayloadCodec())) continue;
            Assert.assertNotNull((Object)codec.intendedSchema());
            Charset cs = codec.getCharset();
            Assert.assertNotNull((Object)cs);
            codec.setCharset(cs);
            Assert.assertEquals((Object)cs, (Object)codec.getCharset());
            this.assertEncodeDecode(codec, "Info", "Hallo");
            this.assertEncodeDecode(codec, "Info", "");
            this.assertEncodeDecode(codec, "", "Hallo");
            this.assertEncodeDecode(codec, "", "");
            this.assertEncodeDecode(codec, null, "Hallo");
            this.assertEncodeDecode(codec, null, "");
        }
    }

    private void assertEncodeDecode(ProtocolServerBuilder.PayloadCodec codec, String info, String data) {
        byte[] payload = data.getBytes();
        byte[] tmp = codec.encode(info, payload);
        Assert.assertNotNull((Object)tmp);
        int len = codec.getDataBytesLength();
        Assert.assertTrue((len > 0 ? 1 : 0) != 0);
        byte[] lenData = new byte[len];
        System.arraycopy(tmp, 0, lenData, 0, len);
        byte[] otherData = new byte[tmp.length - len];
        System.arraycopy(tmp, 4, otherData, 0, otherData.length);
        TestPayloadConsumer consumer = new TestPayloadConsumer();
        codec.decode(otherData, (ProtocolServerBuilder.PayloadConsumer)consumer);
        if (null == info) {
            Assert.assertNull((Object)consumer.info);
        } else {
            Assert.assertEquals((Object)info, (Object)consumer.info);
        }
        Assert.assertArrayEquals((byte[])payload, (byte[])consumer.payload);
    }

    private class TestPayloadConsumer
    implements ProtocolServerBuilder.PayloadConsumer {
        private String info;
        private byte[] payload;

        private TestPayloadConsumer() {
        }

        public void decoded(String info, byte[] payload) {
            this.info = info;
            this.payload = payload;
        }
    }
}

