/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDeploymentRecipe;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.generic.IVABElementHandler;
import org.eclipse.basyx.vab.modelprovider.generic.VABModelProvider;

public class VabIipOperationsProvider
extends HashMap<String, Object> {
    public static final String SEPARATOR = "/";
    public static final String STATUS = "status";
    public static final String PREFIX_STATUS = "status/";
    public static final String OPERATIONS = "operations";
    public static final String PREFIX_OPERATIONS = "operations/";
    public static final String SERVICE = "service";
    public static final String PREFIX_SERVICE = "operations/service/";
    private static final long serialVersionUID = 6355197555283292724L;
    private Map<String, Entry> status = new HashMap<String, Entry>();
    private Map<String, Map<String, Entry>> operations = new HashMap<String, Map<String, Entry>>();
    private Map<String, Entry> service = new HashMap<String, Entry>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<String, Function<Object[], Object>> operationFunctions = new HashMap<String, Function<Object[], Object>>();

    public VabIipOperationsProvider() {
        this.put(this.getStatusPath(), this.status);
        this.put(this.getOperationsPath(), this.operations);
        this.operations.put(this.getServicePath(), this.service);
    }

    protected String getStatusPath() {
        return STATUS;
    }

    protected String getOperationsPath() {
        return OPERATIONS;
    }

    protected String getServicePath() {
        return SERVICE;
    }

    public VABModelProvider createModelProvider() {
        return new VABModelProvider((Object)this, (IVABElementHandler)new VABElementHandler());
    }

    private String makeUnique(Map<String, ?> map, String baseName) {
        String uName = baseName;
        int pos = 1;
        while (this.operationFunctions.containsKey(uName)) {
            uName = baseName + "_" + pos;
            ++pos;
        }
        return uName;
    }

    public VabIipOperationsProvider defineOperation(String category, String name, Function<Object[], Object> function) {
        String uName = this.makeUnique(this.operationFunctions, category + SEPARATOR + name);
        Map<String, Entry> o = this.operations.get(category);
        if (null == o) {
            o = new HashMap<String, Entry>();
            this.operations.put(category, o);
        }
        if (o.containsKey(name)) {
            throw new IllegalArgumentException("Operation " + category + SEPARATOR + name + "is already known.");
        }
        o.put(name, new Entry(Kind.OPERATION, uName));
        this.operationFunctions.put(uName, function);
        return this;
    }

    public VabIipOperationsProvider defineServiceFunction(String name, Function<Object[], Object> function) {
        return this.defineOperation(this.getServicePath(), name, function);
    }

    public VabIipOperationsProvider defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
        if (this.properties.containsKey(name)) {
            throw new IllegalArgumentException("Property " + name + " is already known");
        }
        this.properties.put(name, new Property(get, set));
        this.status.put(name, new Entry(Kind.PROPERTY, name));
        return this;
    }

    private class VABElementHandler
    implements IVABElementHandler {
        private VABElementHandler() {
        }

        public Object postprocessObject(Object element) {
            Object result = element;
            if (element instanceof Property) {
                result = ((Property)element).get.get();
            }
            return result;
        }

        public Object getElementProperty(Object element, String propertyName) {
            Map map = (Map)element;
            Object result = map.get(propertyName);
            if (result instanceof Entry) {
                Entry entry = (Entry)result;
                switch (entry.kind) {
                    case PROPERTY: {
                        result = VabIipOperationsProvider.this.properties.get(entry.uName);
                        break;
                    }
                    case OPERATION: {
                        result = VabIipOperationsProvider.this.operationFunctions.get(entry.uName);
                        break;
                    }
                    default: {
                        throw new ResourceNotFoundException("Unkown entry kind for " + propertyName);
                    }
                }
                if (null == result) {
                    throw new ResourceNotFoundException(entry.kind.name().toLowerCase() + propertyName + " not found.");
                }
            }
            return result;
        }

        public void setModelPropertyValue(Object element, String propertyName, Object newValue) {
            Property prop = (Property)VabIipOperationsProvider.this.properties.get(propertyName);
            if (null == prop) {
                throw new ResourceNotFoundException("Property " + propertyName + " not found.");
            }
            if (null == prop.set) {
                throw new ResourceNotFoundException("Property " + propertyName + " not found (for reading).");
            }
            prop.set.accept(newValue);
        }

        public void createValue(Object element, Object newValue) {
            throw new ResourceNotFoundException("Element " + element + " not supported.");
        }

        public void deleteValue(Object element, String propertyName) {
            throw new ResourceNotFoundException("Element " + element + " not supported.");
        }

        public void deleteValue(Object element, Object property) {
            throw new ResourceNotFoundException("Element " + element + " not found.");
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 3003478232778729891L;
        private Kind kind;
        private String uName;

        private Entry(Kind kind, String uName) {
            this.kind = kind;
            this.uName = uName;
        }
    }

    private static enum Kind {
        PROPERTY,
        OPERATION;

    }

    private static class Property {
        private Consumer<Object> set;
        private Supplier<Object> get;

        private Property(Supplier<Object> get, Consumer<Object> set) {
            this.set = set;
            this.get = get;
        }
    }

    static class VabIipOperationsBuilder
    implements ProtocolServerBuilder {
        private int port;
        private VabIipOperationsProvider instance;

        VabIipOperationsBuilder(int port) {
            this.port = port;
            this.instance = new VabIipOperationsProvider();
        }

        public VabIipOperationsBuilder defineOperation(String name, Function<Object[], Object> function) {
            this.instance.defineServiceFunction(name, function);
            return this;
        }

        public VabIipOperationsBuilder defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
            this.instance.defineProperty(name, get, set);
            return this;
        }

        public Server build() {
            return BaSyxDeploymentRecipe.createControlComponent(this.instance.createModelProvider(), this.port);
        }
    }
}

