/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.Type;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.basyx.aas.metamodel.map.descriptor.CustomId;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetypedef.PropertyValueTypeDef;
import org.slf4j.LoggerFactory;

public class Tools {
    private static final Map<Type, PropertyValueTypeDef> TYPES2BASYX = new HashMap<Type, PropertyValueTypeDef>();
    private static final Map<PropertyValueTypeDef, Type> BASYX2TYPES = new HashMap<PropertyValueTypeDef, Type>();
    private static final Map<AssetKind, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind> ASSETKINDS2BASYX = new HashMap<AssetKind, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind>();
    private static final Map<org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind, AssetKind> BASYX2ASSETKINDS = new HashMap<org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind, AssetKind>();

    private static void mapType(Type type, PropertyValueTypeDef basyxType) {
        TYPES2BASYX.put(type, basyxType);
        BASYX2TYPES.put(basyxType, type);
    }

    private static void mapKind(AssetKind kind, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind basyxKind) {
        ASSETKINDS2BASYX.put(kind, basyxKind);
        BASYX2ASSETKINDS.put(basyxKind, kind);
    }

    public static String checkUrn(String urn) {
        if (null == urn || 0 == urn.length()) {
            throw new IllegalArgumentException("urn must be given");
        }
        return urn;
    }

    public static String checkId(String idShort) {
        if (null == idShort || 0 == idShort.length()) {
            throw new IllegalArgumentException("idShort must be given");
        }
        if (!idShort.matches("[a-zA-Z][a-zA-Z0-9_]+")) {
            throw new IllegalArgumentException("idShort '" + idShort + "' shall only feature letters, digits, underscore (\"_\"); starting mandatory with a letter.");
        }
        if (idShort.equals("value") || idShort.equals("invocationList")) {
            throw new IllegalArgumentException("idShort shall not be \"" + idShort + "\"");
        }
        return idShort;
    }

    public static PropertyValueTypeDef translate(Type type) {
        return TYPES2BASYX.get(type);
    }

    public static Type translate(PropertyValueTypeDef type) {
        return BASYX2TYPES.get(type);
    }

    public static org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind translate(AssetKind kind) {
        return ASSETKINDS2BASYX.get(kind);
    }

    public static AssetKind translate(org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind kind) {
        return BASYX2ASSETKINDS.get(kind);
    }

    static String idToUrlPath(String id) {
        return id;
    }

    public static IIdentifier translateIdentifier(String id, String dfltCustom) {
        Object result = null == id || id.length() == 0 ? new CustomId(dfltCustom) : (id.startsWith("urn:") ? new ModelUrn(id) : new CustomId(id));
        return result;
    }

    public static <E extends Enum<E>> E getOption(String[] options, E dflt, Class<E> cls) {
        E result = dflt;
        for (String o : options) {
            try {
                result = Enum.valueOf(cls, o);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    static void disposeTomcatWorkingDir(File baseDir, int port) {
        File workDir;
        if (null == baseDir) {
            baseDir = new File(".");
        }
        if ((workDir = new File(baseDir, "tomcat." + port)).exists()) {
            if (!FileUtils.deleteQuietly((File)workDir)) {
                try {
                    FileUtils.forceDeleteOnExit((File)workDir);
                }
                catch (IOException iOException) {}
            }
        } else {
            LoggerFactory.getLogger(Tools.class).warn("Tomcat working directory '" + workDir.getAbsolutePath() + "' not found for disposal.");
        }
    }

    static {
        Tools.mapType(Type.BOOLEAN, PropertyValueTypeDef.Boolean);
        Tools.mapType(Type.DOUBLE, PropertyValueTypeDef.Double);
        Tools.mapType(Type.FLOAT, PropertyValueTypeDef.Float);
        Tools.mapType(Type.INTEGER, PropertyValueTypeDef.Integer);
        Tools.mapType(Type.STRING, PropertyValueTypeDef.String);
        Tools.mapType(Type.NON_POSITIVE_INTEGER, PropertyValueTypeDef.NonPositiveInteger);
        Tools.mapType(Type.NON_NEGATIVE_INTEGER, PropertyValueTypeDef.NonNegativeInteger);
        Tools.mapType(Type.POSITIVE_INTEGER, PropertyValueTypeDef.PositiveInteger);
        Tools.mapType(Type.NEGATIVE_INTEGER, PropertyValueTypeDef.NegativeInteger);
        Tools.mapType(Type.INT8, PropertyValueTypeDef.Int8);
        Tools.mapType(Type.INT16, PropertyValueTypeDef.Int16);
        Tools.mapType(Type.INT32, PropertyValueTypeDef.Int32);
        Tools.mapType(Type.INT64, PropertyValueTypeDef.Int64);
        Tools.mapType(Type.UINT8, PropertyValueTypeDef.UInt8);
        Tools.mapType(Type.UINT16, PropertyValueTypeDef.UInt16);
        Tools.mapType(Type.UINT32, PropertyValueTypeDef.UInt32);
        Tools.mapType(Type.UINT64, PropertyValueTypeDef.UInt64);
        Tools.mapType(Type.LANG_STRING, PropertyValueTypeDef.LangString);
        Tools.mapType(Type.ANY_URI, PropertyValueTypeDef.AnyURI);
        Tools.mapType(Type.BASE64_BINARY, PropertyValueTypeDef.Base64Binary);
        Tools.mapType(Type.HEX_BINARY, PropertyValueTypeDef.HexBinary);
        Tools.mapType(Type.NOTATION, PropertyValueTypeDef.NOTATION);
        Tools.mapType(Type.ENTITY, PropertyValueTypeDef.ENTITY);
        Tools.mapType(Type.ID, PropertyValueTypeDef.ID);
        Tools.mapType(Type.IDREF, PropertyValueTypeDef.IDREF);
        Tools.mapType(Type.DURATION, PropertyValueTypeDef.Duration);
        Tools.mapType(Type.DAY_TIME_DURATION, PropertyValueTypeDef.DayTimeDuration);
        Tools.mapType(Type.YEAR_MONTH_DURATION, PropertyValueTypeDef.YearMonthDuration);
        Tools.mapType(Type.DATE_TIME, PropertyValueTypeDef.DateTime);
        Tools.mapType(Type.DATE_TIME_STAMP, PropertyValueTypeDef.DateTimeStamp);
        Tools.mapType(Type.G_DAY, PropertyValueTypeDef.GDay);
        Tools.mapType(Type.G_MONTH, PropertyValueTypeDef.GMonth);
        Tools.mapType(Type.G_MONTH_DAY, PropertyValueTypeDef.GMonthDay);
        Tools.mapType(Type.G_YEAR, PropertyValueTypeDef.GYear);
        Tools.mapType(Type.G_YEAR_MONTH, PropertyValueTypeDef.GYearMonth);
        Tools.mapType(Type.Q_NAME, PropertyValueTypeDef.QName);
        Tools.mapType(Type.NONE, PropertyValueTypeDef.None);
        Tools.mapType(Type.ANY_TYPE, PropertyValueTypeDef.AnyType);
        Tools.mapType(Type.ANY_SIMPLE_TYPE, PropertyValueTypeDef.AnySimpleType);
        Tools.mapKind(AssetKind.TYPE, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind.TYPE);
        Tools.mapKind(AssetKind.INSTANCE, org.eclipse.basyx.aas.metamodel.api.parts.asset.AssetKind.INSTANCE);
    }
}

