/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxConnectedAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxISubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import java.io.IOException;
import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistryService;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.vab.protocol.api.IConnectorProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorProvider;

public class BaSyxRegistry
implements Registry {
    private Endpoint endpoint;
    private IAASRegistryService registry;
    private ConnectedAssetAdministrationShellManager manager;

    BaSyxRegistry(Endpoint endpoint) throws IOException {
        this.endpoint = endpoint;
        try {
            this.registry = new AASRegistryProxy(this.endpoint.toUri());
            HTTPConnectorProvider connectorProvider = new HTTPConnectorProvider();
            this.manager = new ConnectedAssetAdministrationShellManager(this.registry, (IConnectorProvider)connectorProvider);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Aas retrieveAas(String aasUrn) throws IOException {
        return this.obtainAas((IIdentifier)new ModelUrn(aasUrn));
    }

    private BaSyxConnectedAas obtainAas(IIdentifier aasId) throws IOException {
        return new BaSyxConnectedAas(this.manager.retrieveAAS(aasId));
    }

    public Submodel retrieveSubmodel(String aasUrn, String submodelUrn) throws IOException {
        ModelUrn aasURN = new ModelUrn(aasUrn);
        return new BaSyxISubmodel(this.obtainAas((IIdentifier)aasURN), this.manager.retrieveSubModel((IIdentifier)aasURN, (IIdentifier)new ModelUrn(submodelUrn)));
    }

    public void createAas(Aas aas, String endpointURL) {
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be created by the AasFactory.");
        }
        this.manager.createAAS((AssetAdministrationShell)((BaSyxAas)aas).getAas(), endpointURL);
    }

    public void createSubmodel(Aas aas, Submodel submodel) {
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be created by the AasFactory.");
        }
        if (!(submodel instanceof BaSyxSubmodel)) {
            throw new IllegalArgumentException("The submodel must be created by the AasFactory.");
        }
        IIdentifier aasIdentifier = ((AssetAdministrationShell)((BaSyxAas)aas).getAas()).getIdentification();
        this.manager.createSubModel(aasIdentifier, (SubModel)((BaSyxSubmodel)submodel).getSubmodel());
    }

    public void register(Aas aas, Submodel submodel, String endpointUrl) {
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be created by the AasFactory.");
        }
        if (!(submodel instanceof BaSyxSubmodel)) {
            throw new IllegalArgumentException("The submodel must be created by the AasFactory.");
        }
        IIdentifier aasIdentifier = ((AssetAdministrationShell)((BaSyxAas)aas).getAas()).getIdentification();
        this.registry.register(aasIdentifier, new SubmodelDescriptor(submodel.getIdShort(), ((SubModel)((BaSyxSubmodel)submodel).getSubmodel()).getIdentification(), endpointUrl));
    }
}

