/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetypedef.PropertyValueTypeDef;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProviderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaSyxProperty
extends BaSyxSubmodelElement
implements Property {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaSyxOperation.class);
    private IProperty property;

    private BaSyxProperty() {
    }

    BaSyxProperty(IProperty property) {
        this.property = property;
    }

    public String getIdShort() {
        try {
            return this.property.getIdShort();
        }
        catch (ResourceNotFoundException e) {
            return "";
        }
    }

    public Object getValue() throws ExecutionException {
        try {
            return this.property.getValue();
        }
        catch (ResourceNotFoundException e) {
            throw new ExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public void setValue(Object value) throws ExecutionException {
        this.property.set(value);
    }

    IProperty getSubmodelElement() {
        return this.property;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitProperty((Property)this);
    }

    /* synthetic */ BaSyxProperty(BaSyxProperty baSyxProperty) {
        this();
    }

    public static class BaSyxPropertyBuilder
    implements Property.PropertyBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxProperty instance;
        private org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property property;
        private PropertyValueTypeDef typeDef;

        BaSyxPropertyBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort) {
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxProperty(null);
            this.property = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property();
            this.property.setIdShort(Tools.checkId(idShort));
            this.property.setDescription(new LangStrings());
            this.property.setEmbeddedDataSpecifications(new ArrayList());
        }

        public BaSyxSubmodelElementContainerBuilder<?> getParentBuilder() {
            return this.parentBuilder;
        }

        public Property.PropertyBuilder setType(Type type) {
            this.typeDef = Tools.translate(type);
            this.property.setValueType(this.typeDef);
            return this;
        }

        public Property.PropertyBuilder bind(Supplier<Object> get, Consumer<Object> set) {
            if (this.typeDef == null) {
                throw new IllegalArgumentException("setType was not called before");
            }
            if (get != null && set == null) {
                LOGGER.warn("Creating AAS operation " + this.property.getIdShort() + " with only a bound getter " + "can lead to runtime inconsistencies as setting will change the value in the property rather " + "than the value in the underlying representation object.");
            }
            this.property.set((Object)VABLambdaProviderHelper.createSimple(get, set), this.typeDef);
            return this;
        }

        public Property.PropertyBuilder setValue(Type type, Object value) {
            this.setType(type);
            return this.setValue(value);
        }

        public Property.PropertyBuilder setValue(Object value) {
            this.property.set(value);
            return this;
        }

        public Property build() {
            this.instance.property = (IProperty)this.property;
            return this.parentBuilder.register(this.instance);
        }
    }
}

